<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Exporter;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\PostProcess\ExportPostProcessorInterface;
use Myvetshop\Module\Clinique\Accounting\Export\Model\ExportLine;

/**
 * @template DocType of \OrderInvoice|\OrderSlip
 */
interface DocumentExporterInterface
{
    /**
     * @param DocType $document
     *
     * @return ExportLine[]
     */
    public function export($document, \Order $order): array;

    /**
     * @param \OrderInvoice|\OrderSlip $document
     */
    public function supports($document): bool;

    public function addPostProcessor(ExportPostProcessorInterface $postProcessor): void;

    public function removePostProcessor(ExportPostProcessorInterface $postProcessor): void;
}
