<?php

/**
 * Created by Aurélien RICHAUD (16/01/2017 11:40)
 */
class Cart extends CartCore
{
    /**
     * @return array<mixed>|null
     */
    public function getProducts(
        $refresh = false,
        $id_product = false,
        $id_country = null,
        $fullInfos = true, bool $keepOrderPrices = false
    ) {
        $products = parent::getProducts($refresh, $id_product, $id_country, $fullInfos);

        // TODO : Mettre à jour id_supplier & product_supplier_reference en fonction du code privilège
        $context = \Context::getContext();
        \assert(null !== $context);

        $id_supplier = null;

        // Si l'utilisateur est connecté et qu'il a un groupe par défaut
        // On prend le supplier associé !
        if ($context->customer && $context->customer->id && $context->customer->id_default_group) {
            $id_supplier = \Db::getInstance()->getValue(
                '
                SELECT s.`id_supplier`
                FROM `' . _DB_PREFIX_ . 'myvetshop_clinique` mc
                INNER JOIN `' . _DB_PREFIX_ . 'supplier` s ON s.`name` = mc.`centrale`
                WHERE mc.`id_group` = ' . (int) $context->customer->id_default_group
            );

            // Mise à jour des champs si on doit sélectionner un autre supplier que celui par défaut !
            if ($id_supplier) {
                // Si on a trouvé un id_supplier
                foreach ($products as &$product) {
                    $product['id_supplier'] = $id_supplier;

                    // TODO : Mettre à jour product_supplier_reference !
                }
            }

            // Mise à jour du stock (uniquement si refresh)
            $cache = \Cache::getInstance();

            // ///////////////////////////////////////
            // Détermine l'entrepôt à utiliser
            $cache_key = 'MyVetShopCatalogue::getWareHouseForGroup-' . $context->customer->id_default_group;
            if (!$cache->exists($cache_key)) {
                $db = \Db::getInstance();

                $query = 'SELECT `id_warehouse`
                FROM `' . _DB_PREFIX_ . 'myvetshop_clinique`
                WHERE `id_group` = ' . (int) $context->customer->id_default_group
                    . ' OR `id_group_rural` = ' . (int) $context->customer->id_default_group;

                /** @var int|string $id_warehouse */
                $id_warehouse = $db->getValue($query);

                if (!$id_warehouse) {
                    /** @var int|string $id_warehouse */
                    $id_warehouse = \Configuration::get('MYVETSHOP_DEFAULT_WAREHOUSE', 0, 0, 0, 1);
                }
                $cache->set($cache_key, $id_warehouse, 3600);
            } else {
                // Récupération depuis le cache
                /** @var int|string $id_warehouse */
                $id_warehouse = $cache->get($cache_key);
            }

            foreach ($products as &$product) {
                if (isset($product['id_product_attribute']) && $product['id_product_attribute']) {
                    // Calcul du stock réel en fonction de l'entrepot
                    $product['quantity_available'] = \StockManagerFactory::getManager()->getProductRealQuantities(
                        (int) $product['id_product'],
                        (int) $product['id_product_attribute'],
                        (int) $id_warehouse,
                        true
                    );
                } else {
                    $product['quantity_available'] = \StockManagerFactory::getManager()->getProductRealQuantities(
                        (int) $product['id_product'],
                        0,
                        (int) $id_warehouse,
                        true
                    );
                }

                $product['stock_quantity'] = $product['quantity_available'];
            }
        }

        return $products;
    }
}
