<?php

declare(strict_types=1);

/**
 * @deprecated
 * @see Myvetshop\Module\Clinique\Entity\Recommandation
 */
class Recommandation extends ObjectModel
{
    public const TABLE = 'recommandation';

    /**
     * @var int
     */
    public $id_customer;

    /**
     * @var int
     */
    public $id_animal;

    /**
     * @var int
     */
    public $id_recommandation_product;

    /**
     * @var string
     */
    public $code_reco;

    /**
     * @var string
     */
    public $date_reco;

    /**
     * @var string
     */
    public $code_clinique;

    /**
     * @var string
     */
    public $petname;

    /**
     * @var string
     */
    public $espece;

    /**
     * @var string
     */
    public $race;

    /**
     * @var int
     */
    public $id_gender;

    /**
     * @var string
     */
    public $activite;

    /**
     * @var string
     */
    public $age;

    /**
     * @var string|null
     */
    public $date_birth;

    /**
     * @var string
     */
    public $stade_physio;

    /**
     * @var string
     */
    public $pathologie;

    /** @var float */
    public $poids_actuel;

    /** @var float */
    public $poids_ideal;

    /** @var int */
    public $be;

    /** @var int */
    public $nbr_aliment;

    /** @var int */
    public $product_id_mvs1;

    /** @var int|null */
    public $product_id_mvs2;

    /** @var int|null */
    public $product_id_mvs3;

    /** @var int */
    public $qte_aliment1;

    /** @var int|null */
    public $qte_aliment2;

    /** @var int|null */
    public $qte_aliment3;

    /** @var int|null Nombre de mois avant la transition entre l'aliment 1 et l'aliment 2 */
    public $transition12;

    /** @var int|null Nombre de mois avant la transition entre l'aliment 2 et l'aliment 3 */
    public $transition23;

    /** @var string|null Object creation date */
    public $date_add;

    /** @var string|null Object last modification date */
    public $date_upd;

    /** @var bool */
    public $deleted = false;

    /**
     * WARNING : Not persisted
     *
     * @var array<int, array{entity: \Product, quantity: int, months: int}>|null
     */
    public $products;

    /**
     * @var array{table: string, primary: string}
     */
    public static $definition = [
        'table' => self::TABLE,
        'primary' => 'id_recommandation',
        'multilang' => false,
        'multilang_shop' => false,
        'fields' => [
            'id_customer' => ['type' => self::TYPE_INT],
            'id_animal' => ['type' => self::TYPE_INT],
            'code_reco' => ['type' => self::TYPE_STRING],
            'date_reco' => ['type' => self::TYPE_DATE, 'validate' => 'isDate'],
            'code_clinique' => ['type' => self::TYPE_STRING],
            'petname' => ['type' => self::TYPE_STRING],
            'espece' => ['type' => self::TYPE_STRING],
            'race' => ['type' => self::TYPE_STRING],
            'id_gender' => ['type' => self::TYPE_INT],
            'activite' => ['type' => self::TYPE_STRING],
            'age' => ['type' => self::TYPE_STRING],
            'date_birth' => ['type' => self::TYPE_STRING],
            'stade_physio' => ['type' => self::TYPE_STRING],
            'pathologie' => ['type' => self::TYPE_STRING],
            'poids_actuel' => ['type' => self::TYPE_FLOAT],
            'poids_ideal' => ['type' => self::TYPE_FLOAT],
            'be' => ['type' => self::TYPE_INT],
            'nbr_aliment' => ['type' => self::TYPE_INT],

            'id_recommandation_product' => ['type' => self::TYPE_INT],

            'product_id_mvs1' => ['type' => self::TYPE_INT],
            'product_id_mvs2' => ['type' => self::TYPE_INT],
            'product_id_mvs3' => ['type' => self::TYPE_INT],
            'qte_aliment1' => ['type' => self::TYPE_INT],
            'qte_aliment2' => ['type' => self::TYPE_INT],
            'qte_aliment3' => ['type' => self::TYPE_INT],
            'transition12' => ['type' => self::TYPE_INT],
            'transition23' => ['type' => self::TYPE_INT],

            'date_add' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
            'date_upd' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
            'deleted' => ['type' => self::TYPE_BOOL],
        ],
    ];

    public function hasCustomer(int $customerId): bool
    {
        return $this->id_customer == $customerId;
    }

    public static function codeExist(string $code): bool
    {
        $query = 'SELECT  COUNT(id_recommandation)
             FROM `' . _DB_PREFIX_ . self::$definition['table'] . '` `r`
             WHERE `r`.`deleted` = 0 AND `r`.`code_reco` = "' . Db::getInstance()->escape($code) . '"';

        return Db::getInstance()->getValue($query) > 0;
    }

    public static function install(): bool
    {
        $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . static::TABLE . '` (
            `id_recommandation` INT(11) NOT NULL AUTO_INCREMENT,
            `id_customer` INT(11) NOT NULL,
            `id_animal` INT(11) NULL,
            `id_recommandation_product` INT(11) NULL,
            `code_reco` VARCHAR(6) NULL,
            `date_reco` DATETIME NOT NULL,
            `code_clinique` INT(6) NULL,
            `petname` VARCHAR(50) NOT NULL,
            `espece` VARCHAR(50) NOT NULL,
            `race` VARCHAR(50) NOT NULL,
            `id_gender` INT(11) NOT NULL,
            `activite` VARCHAR(60) NOT NULL,
            `age` VARCHAR(60) NOT NULL,
            `date_birth` VARCHAR(50) NULL,
            `pathologie` VARCHAR(60) NULL,
            `stade_physio` VARCHAR(60) NOT NULL,
            `poids_actuel` DECIMAL(20,2) NOT NULL,
            `poids_ideal` DECIMAL(20,2) NOT NULL,
            `be` INT(11) NULL,
            `nbr_aliment` INT(11) NOT NULL,
            `product_id_mvs1` INT(11) NOT NULL,
            `product_id_mvs2` INT(11) NULL,
            `product_id_mvs3` INT(11) NULL,
            `qte_aliment1` INT(11) NOT NULL,
            `qte_aliment2` INT(11) NULL,
            `qte_aliment3` INT(11) NULL,
            `transition12` INT(11) NULL,
            `transition23` INT(11) NULL,
            `date_add` DATETIME NOT NULL,
            `date_upd` DATETIME NOT NULL,
            `deleted` TINYINT(1) NOT NULL,
            PRIMARY KEY (`id_recommandation`)
        )';

        return Db::getInstance()->execute($query);
    }

    public function delete()
    {
        $this->deleted = true;

        return parent::save();
    }
}
