<?php

declare(strict_types=1);

/**
 * @deprecated
 */
class MyvetshopRecommandationProduct extends ObjectModel
{
    /**
     * @var int
     */
    public $id_recommandation;

    /**
     * @var int
     */
    public $id_product;

    /**
     * @var int
     */
    public $id_recommandation_product_next;

    /**
     * @var int
     */
    public $quantity;

    /**
     * @var int
     */
    public $months;

    /**
     * @var array<mixed>
     */
    public static $definition = [
        'table' => 'recommandation_product',
        'primary' => 'id_recommandation_product',
        'fields' => [
            'id_recommandation' => ['type' => self::TYPE_INT],
            'id_product' => ['type' => self::TYPE_INT],
            'id_recommandation_product_next' => ['type' => self::TYPE_INT],
            'quantity' => ['type' => self::TYPE_INT],
            'months' => ['type' => self::TYPE_INT],
        ],
    ];

    public function isNextOf(int $recommandationProductId): bool
    {
        $recommandationProduct = new self($recommandationProductId);

        if (
            !Validate::isLoadedObject($recommandationProduct)
            || !$recommandationProduct->id_recommandation_product_next
        ) {
            return false;
        }

        if ($recommandationProduct->id_recommandation_product_next == $this->id) {
            return true;
        }

        return $this->isNextOf($recommandationProduct->id_recommandation_product_next);
    }

    public function getPrevious(): ?self
    {
        $query = 'SELECT id_recommandation_product'
            . ' FROM ' . _DB_PREFIX_ . self::$definition['table']
            . ' WHERE id_recommandation_product_next=' . (int) $this->id;
        $recommandationProductId = \intval(Db::getInstance()->getValue($query));
        $recommandationProduct = new self($recommandationProductId);

        return Validate::isLoadedObject($recommandationProduct) ? $recommandationProduct : null;
    }

    public function getNext(): ?self
    {
        $recommandationProduct = new self($this->id_recommandation_product_next);

        return Validate::isLoadedObject($recommandationProduct) ? $recommandationProduct : null;
    }

    public function hasNext(): bool
    {
        return null !== $this->getNext();
    }

    public function getProduct(): Product
    {
        $context = Context::getContext();
        \assert(null !== $context);

        return new Product($this->id_product, false, $context->language->id);
    }

    /**
     * @return MyvetshopRecommandationProduct[]
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public static function getByRecommandationId(int $recommandationId): array
    {
        $query = 'SELECT id_recommandation_product'
            . ' FROM ' . _DB_PREFIX_ . self::$definition['table']
            . ' WHERE id_recommandation=' . $recommandationId;
        $rows = Db::getInstance()->executeS($query);
        if (!\is_array($rows)) {
            $rows = [];
        }

        $list = \array_column($rows, 'id_recommandation_product');

        return array_map(fn ($recommandationProductId) => new self($recommandationProductId), $list);
    }

    public static function install(): bool
    {
        $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '` (
              `id_recommandation_product` INT(11) NOT NULL AUTO_INCREMENT,
              `id_recommandation` INT(11) NOT NULL,
              `id_product` INT(11) NOT NULL,
              `id_recommandation_product_next` INT(11) NULL,
              `quantity` INT(11) NOT NULL NULL,
              `months` INT(11) NULL,
               PRIMARY KEY (`id_recommandation_product`)
            );';

        return Db::getInstance()->execute($query);
    }
}
