<?php

namespace App\Tests\A_Unit\Import\Serializer;

use Myvetshop\Module\Clinique\Import\Model\CustomerModel;
use Myvetshop\Module\Clinique\Import\Serializer\CustomerModelNormalizer;
use PHPUnit\Framework\TestCase;

class CustomerModelNormalizerTest extends TestCase
{
    private CustomerModelNormalizer $normalizer;

    protected function setUp(): void
    {
        $this->normalizer = new CustomerModelNormalizer();
    }

    public function testDenormalize(): void
    {
        // Assuming a dummy customer data object.
        $dummyData = [
            'id_customer' => '1',
            'id_shop_group' => '2',
            'id_shop' => '3',
            'id_store' => '4',
            'id_gender' => '5',
            'id_default_group' => '6',
            'id_lang' => '7',
            'id_risk' => '8',
            'company' => null,
            'siret' => null,
            'ape' => null,
            'firstname' => 'John',
            'lastname' => 'Doe',
            'email' => 'john.doe@example.com',
            'passwd' => 'plaintext_password',
            'last_passwd_gen' => \date('Y-m-d H:i:s'),
            'birthday' => '1990-01-01',
            'active' => '1',
            'is_guest' => '0',
            'newsletter' => '0',
            'ip_registration_newsletter' => '10.10.10.10',
            'newsletter_date_add' => '0000-00-00',
            'optin' => '1',
            'website' => '',
            'outstanding_allow_amount' => '0.000',
            'show_public_prices' => '1',
            'secure_key' => '123456',
            'note' => '',
            'deleted' => '0',
            'date_add' => \date('Y-m-d H:i:s'),
            'date_upd' => \date('Y-m-d H:i:s'),
        ];

        $customer = $this->normalizer->denormalize($dummyData, CustomerModel::class);

        $this->assertInstanceOf(CustomerModel::class, $customer);
        $this->assertEquals(1, $customer->idCustomer);
        $this->assertEquals('John', $customer->firstname);
        $this->assertEquals('Doe', $customer->lastname);
    }

    public function testExceptionThrownWhenDenormalizeNonArrayData(): void
    {
        $this->expectException(\Exception::class);
        $this->normalizer->denormalize('string', CustomerModel::class);
    }

    public function testSupportsDenormalization(): void
    {
        $this->assertTrue($this->normalizer->supportsDenormalization([], CustomerModel::class));
        $this->assertFalse($this->normalizer->supportsDenormalization([], \DateTime::class));
    }
}
