<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Iterator;

/**
 * @extends AbstractChunkIterator<\OrderInvoice>
 */
class OrderInvoiceChunkIterator extends AbstractChunkIterator
{
    public function count()
    {
        if (null == $this->chunkCount) {
            $this->chunkCount = (int) \ceil($this->countElements() / AbstractChunkIterator::CHUNK_SIZE);
        }

        return $this->chunkCount;
    }

    public function countElements(): int
    {
        if (null === $this->elementCount) {
            $this->elementCount = $this->documentSource->getOrderInvoicesCount(
                $this->startDate,
                $this->endDate
            );
        }

        return $this->elementCount;
    }

    public function current()
    {
        return $this->documentSource->getOrderInvoices(
            $this->startDate,
            $this->endDate,
            $this->i * AbstractChunkIterator::CHUNK_SIZE,
            AbstractChunkIterator::CHUNK_SIZE
        );
    }
}
