<?php

declare(strict_types=1);

namespace Myvetshop\Module\Clinique\Serializer;

use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ArrayDenormalizer;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Serializer;

/**
 * @template T
 */
abstract class AbstractReportingSerializer
{
    protected Serializer $serializer;

    /**
     * @return DenormalizerInterface[]
     */
    abstract public static function getNormalizers(): array;

    /**
     * @return class-string<T>
     */
    abstract public static function getModelClass(): string;

    public function __construct()
    {
        $this->serializer = new Serializer([...static::getNormalizers(), new ArrayDenormalizer()], [new JsonEncoder()]);
    }

    /**
     * @param array<string, mixed>[] $data
     */
    public function serialize(array $data): string
    {
        $denormalized = $this->serializer->denormalize($data, static::getModelClass() . '[]');

        return $this->serializer->serialize($denormalized, 'json');
    }
}
