<?php

declare(strict_types=1);

/**
 * Created by Aurélien RICHAUD (23/05/2018 17:03).
 */
class Order extends OrderCore
{
    /**
     * @return array<int, array<string, mixed>>
     */
    public function getHistoryWS(): array
    {
        return $this->getHistory(1);
    }

    /**
     * @return array<mixed>
     */
    public function getWebserviceParameters($ws_params_attribute_name = null): array
    {
        $resource_parameters = parent::getWebserviceParameters($ws_params_attribute_name);

        $resource_parameters['fields']['date_add']['setter'] = false;

        return $resource_parameters;
    }

    /**
     * @param int $order_invoice_id
     * @param int $id_shop
     *
     * @return bool
     */
    public static function setLastInvoiceNumber($order_invoice_id, $id_shop)
    {
        if (!$order_invoice_id) {
            return false;
        }

        $sql = 'UPDATE `' . _DB_PREFIX_ . 'order_invoice`'
            . ' SET number = NEXTVAL(myvetshop_invoice_number)'
            . ' WHERE `id_order_invoice` = ' . (int) $order_invoice_id;

        return \Db::getInstance()->execute($sql);
    }
}
