<?php

namespace App\Tests\A_Unit\Import\Dixptz\Clinic;

use Myvetshop\Module\Clinique\Import\Dixptz\Clinic\ClinicImportFileProvider;
use Myvetshop\Module\Clinique\Import\Dixptz\Model\ClinicModel;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class ClinicImportFileProviderTest extends TestCase
{
    /**
     * @var ClinicImportFileProvider&MockObject
     */
    private $provider;

    public function setUp(): void
    {
        $this->provider = $this->createPartialMock(ClinicImportFileProvider::class, ['open']);
    }

    /**
     * Test to ensure the correct clinics are being returned.
     */
    public function testGetClinics(): void
    {
        $csv = \fopen('php://memory', 'w');
        \assert(false !== $csv);

        \fwrite($csv, 'code_privilege;centrale;code_coveto;nom_10ptz;nom_myvetshop;adresse1;adresse2;'
            . 'code_postal;ville;latitude;longitude;email;site_internet;livraison_lundi;livraison_mardi;'
            . 'livraison_mercredi;livraison_jeudi;livraison_vendredi;livraison_samedi;phone;siret;rcs;tva;hours' . "\n"
        );
        \fwrite($csv, 'VTP170;coveto;99555;Clinique Nantes La Montagne;Clinique Nantes La Montagne;'
            . '16 avenue de la rue;;24560;LA MONTAGNE;47.17600200;-1.67987400;reception@clinique-lamontagne.com;'
            . 'http://www.clinique-lamontagne.com;x;x;x;x;x;;03 80 99 32 25;45079188400015;Nantes;FR15059788414;'
            . '"a:7:{i:0;s:17:""de 08:00 à 20:00"";i:1;s:17:""de 08:00 à 20:00"";i:2;s:17:""de 08:00 à 20:00"";'
            . 'i:3;s:17:""de 08:00 à 20:00"";i:4;s:17:""de 08:00 à 20:00"";i:5;s:17:""de 09:00 à 19:00"";i:6;'
            . 's:26:""Urgences au 03 80 99 32 25"";}"' . "\n"
        );
        \rewind($csv);

        $this->provider
            ->method('open')
            ->willReturn($csv);

        $clinics = $this->provider->getClinics(null);

        $this->assertIsArray($clinics);
        $this->assertEquals(1, count($clinics));
        $this->assertInstanceOf(ClinicModel::class, $clinics[0]);
        $this->assertEquals('VTP170', $clinics[0]->codePrivilege);
        $this->assertEquals('99555', $clinics[0]->codeCoveto);
        $this->assertEquals('Clinique Nantes La Montagne', $clinics[0]->nomMyvetshop);
        $this->assertEquals('reception@clinique-lamontagne.com', $clinics[0]->email);
        $this->assertEquals('47.17600200', $clinics[0]->latitude);
        $this->assertEquals('-1.67987400', $clinics[0]->longitude);
        $this->assertEquals('http://www.clinique-lamontagne.com', $clinics[0]->siteInternet);
        $this->assertEquals('de 08:00 à 20:00', $clinics[0]->hours[0]);
        $this->assertEquals('de 08:00 à 20:00', $clinics[0]->hours[1]);
        $this->assertEquals('de 08:00 à 20:00', $clinics[0]->hours[2]);
        $this->assertEquals('de 08:00 à 20:00', $clinics[0]->hours[3]);
        $this->assertEquals('de 08:00 à 20:00', $clinics[0]->hours[4]);
        $this->assertEquals('de 09:00 à 19:00', $clinics[0]->hours[5]);
        $this->assertEquals('Urgences au 03 80 99 32 25', $clinics[0]->hours[6]);
    }
}
