<?php

namespace App\Tests\A_Unit\Adapter\Controller\Front;

use Doctrine\ORM\EntityManagerInterface;
use Myvetshop\Module\Clinique\Adapter\Controller\Front\MyRecoDeleteControllerAdapter;
use Myvetshop\Module\Clinique\Entity\Recommandation;
use Myvetshop\Module\Clinique\Repository\RecommandationRepository;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\Request;

class MyRecoDeleteControllerAdapterTest extends TestCase
{
    private MyRecoDeleteControllerAdapter $adapter;

    /**
     * @var EntityManagerInterface&MockObject
     */
    private EntityManagerInterface $mockEntityManager;

    /**
     * @var RecommandationRepository&MockObject
     */
    private RecommandationRepository $mockRecommandationRepository;

    protected function setUp(): void
    {
        $this->mockRecommandationRepository = $this->createMock(RecommandationRepository::class);
        $this->mockEntityManager = $this->createMock(EntityManagerInterface::class);

        $this->adapter = new MyRecoDeleteControllerAdapter(
            $this->mockEntityManager,
            $this->mockRecommandationRepository
        );
    }

    public function testHandleRequestNonExistentRecommandation(): void
    {
        $request = new Request();
        $request->query = new ParameterBag([
            'id_recommandation' => '999',
        ]);

        $context = $this->createMock(\Context::class);
        $context->customer = $this->createMock(\Customer::class);
        $context->customer->id = 1;

        $this->mockRecommandationRepository
            ->expects($this->once())
            ->method('findOneBy')
            ->with($this->equalTo([
                'id' => '999',
                'idCustomer' => 1,
                'deleted' => false,
            ]))
            ->willReturn(null);

        $result = $this->adapter->handleRequest($context, $request);

        $this->assertCount(1, $result['errors'] ?? []);
        $this->assertContains('Recommandation non trouvée', $result['errors'] ?? []);
    }

    public function testHandleRequestExistsRecommandation(): void
    {
        $request = new Request();
        $request->query = new ParameterBag([
            'id_recommandation' => '1',
        ]);

        $context = $this->createMock(\Context::class);
        $context->customer = $this->createMock(\Customer::class);
        $context->customer->id = 1;

        $recommandation = new Recommandation();

        $this->mockRecommandationRepository
            ->expects($this->once())
            ->method('findOneBy')
            ->with($this->equalTo([
                'id' => 1,
                'idCustomer' => 1,
                'deleted' => false,
            ]))
            ->willReturn($recommandation);

        $this->mockEntityManager
            ->expects($this->once())
            ->method('flush');

        $result = $this->adapter->handleRequest($context, $request);

        $this->assertCount(1, $result['success'] ?? []);
        $this->assertContains('La recommandation a bien été supprimée !', $result['success'] ?? []);
    }
}
