<?php

declare(strict_types=1);

if (!\defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_2_0_0(myvetshopclinique $module): bool
{
    $db = Db::getInstance();

    $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'myvetshop_clinique` (
              `id_myvetshop_clinique` INT(11) NOT NULL AUTO_INCREMENT,
              `id_sso` int(11) DEFAULT NULL,
              `id_employee` int(11) DEFAULT NULL,
              `id_carrier` int(11) DEFAULT NULL,
              `id_carrier_home` int(11) DEFAULT NULL,
              `id_group` int(11) DEFAULT NULL,
              `id_group_rural` int(11) DEFAULT NULL,
              `id_store` int(11) DEFAULT NULL,
              `code_privilege` varchar(10) NOT NULL,
              `centrale` varchar(10) NOT NULL,
              `id_warehouse` int(11) DEFAULT NULL,
              `code_client` varchar(10) DEFAULT NULL,
              `mdp` varchar(10) DEFAULT NULL,
              `code_filiere` varchar(10) DEFAULT NULL,
              `theme` varchar(10) DEFAULT NULL,
              `masquer_logo` int(1) DEFAULT 0,
              `email_original` varchar(150) DEFAULT NULL,
              `jours_livraison` varchar(55) DEFAULT NULL,
              `url_rendez_vous` varchar(250) DEFAULT NULL,
              `message` text DEFAULT NULL,
              `rurale` int(1) DEFAULT NULL,
              `vetoAprenom` varchar(55) DEFAULT NULL,
              `vetoAnom` varchar(55) DEFAULT NULL,
              `vetoAurlrdv` varchar(100) DEFAULT NULL,
              `vetoBprenom` varchar(55) DEFAULT NULL,
              `vetoBnom` varchar(55) DEFAULT NULL,
              `vetoBurlrdv` varchar(100) DEFAULT NULL,
              `vetoCprenom` varchar(55) DEFAULT NULL,
              `vetoCnom` varchar(55) DEFAULT NULL,
              `vetoCurlrdv` varchar(100) DEFAULT NULL,
              `vetoDprenom` varchar(55) DEFAULT NULL,
              `vetoDnom` varchar(55) DEFAULT NULL,
              `vetoDurlrdv` varchar(100) DEFAULT NULL,
              `vetoEprenom` varchar(55) DEFAULT NULL,
              `vetoEnom` varchar(55) DEFAULT NULL,
              `vetoEurlrdv` varchar(100) DEFAULT NULL,
              `deleted` int(1) NOT NULL DEFAULT 0,
              `don` tinyint(1) DEFAULT 1,
              `email_delivery_notes` int(1) NOT NULL DEFAULT 1,
              `blockedProducts` TEXT DEFAULT NULL,
              `blockedProductsMessage` TEXT DEFAULT NULL,
              `name` VARCHAR(255) DEFAULT NULL,
              `id_theme` int(11) DEFAULT NULL,
              `email_factures` int(1) NOT NULL DEFAULT "0",
              `apiKey` varchar(64) NOT NULL,

               PRIMARY KEY (`id_myvetshop_clinique`),
               UNIQUE (id_employee),
               UNIQUE (id_carrier),
               UNIQUE (id_group),
               UNIQUE (id_store),
               UNIQUE (code_privilege)
            );';

    if (!$db->execute($query)) {
        return false;
    }

    $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'myvetshop_clinique_holidays` (
              `id_myvetshop_clinique_holidays`  INT(11) NOT NULL AUTO_INCREMENT,
              `id_myvetshop_clinique` INT(11) NOT NULL,
              `date_alerte` DATE NULL,
              `date_debut` DATE NOT NULL,
              `date_fin` DATE NOT NULL,
              `message_alerte` TEXT NULL,
              `message` TEXT NOT NULL,
               PRIMARY KEY (id_myvetshop_clinique_holidays)
            );';

    if (!$db->execute($query)) {
        return false;
    }

    $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'clinique_push` (
              `id_clinique_push` INT(11) NOT NULL AUTO_INCREMENT,
              `push_id` VARCHAR(255) NOT NULL,
              `push_type` VARCHAR(10) NOT NULL,
              `id_oauth_access_token` INT(11),
              `date_add` DATE NOT NULL,
              `date_upd` DATE NOT NULL,

               PRIMARY KEY (`id_clinique_push`)
            );';

    if (!$db->execute($query)) {
        return false;
    }

    $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'myvetshop_export_product` (
              `id_export_product` INT(11) NOT NULL AUTO_INCREMENT,
              `id_myvetshop_clinique` INT(11) NOT NULL,
              `name` VARCHAR(50) NOT NULL,
              `date_start` DATE NOT NULL,
              `date_end` DATE NOT NULL,
              `products` TEXT  NOT NULL,
              `date_add` DATE NOT NULL,
              `date_upd` DATE NOT NULL,
              `deleted` BOOL NOT NULL DEFAULT FALSE,

               PRIMARY KEY (`id_export_product`)
            );';

    if (!$db->execute($query)) {
        return false;
    }

    $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'establishment_event` (
              `id_establishment_event` INT(11) NOT NULL AUTO_INCREMENT,
              `id_myvetshop_clinique` INT(11) NOT NULL,
              `event` VARCHAR(20) NOT NULL,
              `id_customer` INT(11) DEFAULT NULL,
              `customer_data` LONGTEXT DEFAULT NULL,
              `id_order` INT(11) DEFAULT NULL,
              `order_data` LONGTEXT DEFAULT NULL,
              `date_add` DATETIME NOT NULL,
               PRIMARY KEY (`id_establishment_event`)
            );';

    if (!$db->execute($query)) {
        return false;
    }

    $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'recommandation` (
            `id_recommandation` INT(11) NOT NULL AUTO_INCREMENT,
            `id_customer` INT(11) NOT NULL,
            `id_animal` INT(11) NULL,
            `id_recommandation_product` INT(11) NULL,
            `code_reco` VARCHAR(6) NULL,
            `date_reco` DATETIME NOT NULL,
            `code_clinique` VARCHAR(6) NULL,
            `petname` VARCHAR(50) NOT NULL,
            `espece` VARCHAR(50) NOT NULL,
            `race` VARCHAR(50) NOT NULL,
            `id_gender` INT(11) NOT NULL,
            `activite` VARCHAR(60) NOT NULL,
            `age` VARCHAR(60) NOT NULL,
            `date_birth` VARCHAR(50) NULL,
            `pathologie` VARCHAR(60) NULL,
            `stade_physio` VARCHAR(60) NOT NULL,
            `poids_actuel` DECIMAL(20,2) NOT NULL,
            `poids_ideal` DECIMAL(20,2) NOT NULL,
            `be` INT(11) NULL,
            `nbr_aliment` INT(11) NOT NULL,
            `product_id_mvs1` INT(11) NOT NULL,
            `product_id_mvs2` INT(11) NULL,
            `product_id_mvs3` INT(11) NULL,
            `qte_aliment1` INT(11) NOT NULL,
            `qte_aliment2` INT(11) NULL,
            `qte_aliment3` INT(11) NULL,
            `transition12` INT(11) NULL,
            `transition23` INT(11) NULL,
            `date_add` DATETIME NOT NULL,
            `date_upd` DATETIME NOT NULL,
            `deleted` TINYINT(1) NOT NULL,
            PRIMARY KEY (`id_recommandation`)
        )';

    if (!$db->execute($query)) {
        return false;
    }

    $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'customer_push` (
            `id_customer_push` int(11) NOT NULL,
            `id_customer` int(11) NOT NULL,
            `push_id` varchar(255) NOT NULL,
            `push_type` varchar(10) NOT NULL,
            `is_lettre_information` int(1) DEFAULT NULL,
            `is_commande` int(1) DEFAULT NULL,
            `is_promos` int(1) DEFAULT NULL,
            `is_clinique` int(1) DEFAULT NULL,
            `is_animaux` int(1) DEFAULT NULL,
            `id_oauth_access_token` int(11) DEFAULT NULL,
            `date_add` datetime NOT NULL,
            `date_upd` datetime NOT NULL,
            `deleted` int(1) NOT NULL DEFAULT 0,
            PRIMARY KEY (`id_customer_push`)
        )';

    if (!$db->execute($query)) {
        return false;
    }

    $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'animal` (
            `id_animal` int(11) NOT NULL,
            `id_customer` int(11) NOT NULL,
            `espece` varchar(50) DEFAULT NULL,
            `nom` varchar(100) NOT NULL,
            `race` varchar(255) DEFAULT NULL,
            `id_gender` int(11) NOT NULL,
            `robe` varchar(100) DEFAULT NULL,
            `date_naissance` date DEFAULT NULL,
            `ration` int(11) NOT NULL,
            `id_product` int(11) NOT NULL,
            `id_product_attribute` int(11) NOT NULL,
            `date_add` datetime NOT NULL,
            `date_upd` datetime NOT NULL,
            `deleted` int(1) NOT NULL DEFAULT 0,
            PRIMARY KEY (`id_animal`)
        )';

    if (!$db->execute($query)) {
        return false;
    }

    $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'animal_sac` (
            `id_animal_sac` int(11) NOT NULL,
            `id_animal` int(11) NOT NULL,
            `id_product` int(11) NOT NULL,
            `id_product_attribute` int(11) NOT NULL,
            `product_name` varchar(255) NOT NULL,
            `product_reference` varchar(10) NOT NULL,
            `product_ean13` varchar(14) NOT NULL,
            `id_order` int(11) DEFAULT NULL,
            `date_achat` date NOT NULL,
            `date_fin_estimee` date NOT NULL,
            `poids_net` int(11) NOT NULL,
            `nombre_rations` int(11) DEFAULT NULL,
            `nombre_rations_biais` int(11) NOT NULL DEFAULT 0,
            `date_add` datetime NOT NULL,
            `date_upd` datetime NOT NULL,
            PRIMARY KEY (`id_animal_sac`)
        )';

    if (!$db->execute($query)) {
        return false;
    }

    $query = 'ALTER TABLE `' . _DB_PREFIX_ . 'product`
        ADD COLUMN IF NOT EXISTS net_weight	decimal(20,6) NOT NULL DEFAULT 0.0 AFTER weight';

    if (!$db->execute($query)) {
        return false;
    }

    $query = 'ALTER TABLE `' . _DB_PREFIX_ . 'product_attribute`
        ADD COLUMN IF NOT EXISTS net_weight	decimal(20,6) NOT NULL DEFAULT 0.0';

    if (!$db->execute($query)) {
        return false;
    }

    return true;
}
