<?php

namespace Myvetshop\Module\Clinique\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Myvetshop\Module\Clinique\Entity\ProductFood;

class ProductFoodRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ProductFood::class);
    }

    public function findByProductId(int $idProduct): ?ProductFood
    {
        /** @var ProductFood|null $productFood */
        $productFood = $this->findOneBy(['idProduct' => $idProduct]);

        return $productFood;
    }
}
