<?php

namespace Myvetshop\Module\Clinique\Import\Dixptz\Serializer;

use Myvetshop\Module\Clinique\Import\Dixptz\Model\RewardModel;

class RewardModelNormalizer extends \Myvetshop\Module\Clinique\Import\Serializer\RewardModelNormalizer
{
    /**
     * @param array<mixed> $data
     *
     * @return RewardModel
     */
    public function denormalize($data, $type, $format = null, array $context = [])
    {
        /** @var RewardModel $ret */
        $ret = parent::denormalize($data, $type, $format, ['object' => new RewardModel()]);

        \assert(\is_array($data));

        $ret->currentPoints = \intval($data['current_points']);
        $ret->ca2024 = \floatval($data['ca_2024']);
        $ret->points2024 = \intval($data['points_2024']);
        $ret->ratio100Points = \intval($data['ratio_100_points']);
        $ret->montantReduction = \floatval($data['montant_reduction']);
        $ret->pointsMyVetshop = \intval($data['points_myvetshop']);

        return $ret;
    }

    public function supportsDenormalization($data, $type, $format = null)
    {
        return RewardModel::class === $type;
    }
}
