<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_recommandation_product")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\RecommandationProductRepository")
 */
class RecommandationProduct
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(type="integer", name="id_recommandation_product", nullable=false)
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\ManyToOne(targetEntity="Myvetshop\Module\Clinique\Entity\Recommandation", inversedBy="produits")
     *
     * @ORM\JoinColumn(name="id_recommandation", referencedColumnName="id_recommandation")
     */
    public Recommandation $recommandation;

    /**
     * @ORM\Column(type="integer", name="id_product", nullable=false)
     */
    public int $idProduct;

    /**
     * @ORM\Column(type="integer", name="id_recommandation_product_next", nullable=true)
     */
    public ?int $idRecommandationProductNext = null;

    /**
     * @ORM\Column(type="integer", name="quantity", nullable=true)
     */
    public ?int $quantity;

    /**
     * @ORM\Column(type="integer", name="months", nullable=true)
     */
    public ?int $months;

    public function getId(): ?int
    {
        return $this->id;
    }
}
