<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Iterator;

use Myvetshop\Module\Clinique\Accounting\Export\DocumentSource;

/**
 * @template DocType of \OrderInvoice|\OrderSlip
 *
 * @implements ChunkIteratorInterface<DocType>
 */
abstract class AbstractChunkIterator implements ChunkIteratorInterface
{
    public const CHUNK_SIZE = 1000;

    protected DocumentSource $documentSource;
    protected \DateTimeImmutable $startDate;
    protected \DateTimeImmutable $endDate;

    protected int $i = 0;

    protected ?int $elementCount = null;

    protected ?int $chunkCount = null;

    public function __construct(
        DocumentSource $documentSource,
        \DateTimeImmutable $startDate,
        \DateTimeImmutable $endDate
    ) {
        $this->documentSource = $documentSource;
        $this->startDate = $startDate;
        $this->endDate = $endDate;
    }

    public function next()
    {
        ++$this->i;
    }

    public function key()
    {
        return $this->i;
    }

    public function valid()
    {
        return $this->i < $this->count();
    }

    public function rewind()
    {
        $this->i = 0;
    }
}
