<?php

class NoOpCache extends Cache
{
    /**
     * Cache a data
     *
     * @param string $key
     * @param mixed $value
     * @param int $ttl
     *
     * @return bool
     */
    protected function _set($key, $value, $ttl = 0)
    {
        return false;
    }

    /**
     * Retrieve a cached data by key
     *
     * @param string $key
     *
     * @return mixed
     */
    protected function _get($key)
    {
        return null;
    }

    /**
     * Check if a data is cached by key
     *
     * @param string $key
     *
     * @return bool
     */
    protected function _exists($key)
    {
        return false;
    }

    /**
     * Delete a data from the cache by key
     *
     * @param string $key
     *
     * @return bool
     */
    protected function _delete($key)
    {
        return true;
    }

    /**
     * Write keys index
     *
     * @return bool
     */
    protected function _writeKeys()
    {
        return false;
    }

    /**
     * Clean all cached data
     *
     * @return bool
     */
    public function flush()
    {
        return true;
    }
}
