<div id="container-customer">
    <div class="row">
        {*left*}
        <div class="col-lg-6">
            <div class="panel clearfix">
                <div class="panel-heading">
                    <i class="icon-user"></i>
                    {$clinique->code_privilege}
                    [{$clinique->id_myvetshop_clinique|string_format:"%06d"}]
                    -
                    <a href="mailto:{$clinique->code_privilege}@myvetshop.fr"><i class="icon-envelope"></i>
                        {$clinique->code_privilege}@myvetshop.fr
                    </a>
                    <div class="panel-heading-action">
                        <a class="btn btn-default"
                           href="{$current|escape:'html':'UTF-8'}&amp;updatemyvetshop_clinique&amp;id_myvetshop_clinique={$clinique->id_myvetshop_clinique|intval}&amp;token={$token|escape:'html':'UTF-8'}&amp;back={$smarty.server.REQUEST_URI|urlencode}">
                            <i class="icon-edit"></i>
                            {l s='Edit'}
                        </a>
                    </div>
                </div>
                <div class="form-horizontal">
                    <div class="row">
                        <label class="control-label col-lg-3">Identité</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {$clinique->name}
                            </p>
                        </div>
                    </div>

                    <div class="row">
                        <label class="control-label col-lg-3">Code privilège</label>
                        <div class="col-lg-9 form-control-static">
                            <p>{$clinique->code_privilege}</p>
                        </div>
                    </div>

                    <div class="row">
                        <label class="control-label col-lg-3">E-mail</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {$employee->email}
                            </p>
                        </div>
                    </div>

                    {if $store->website}
                        <div class="row">
                            <label class="control-label col-lg-3">Site internet</label>
                            <div class="col-lg-9 form-control-static">
                                <p>
                                    <a href="{$store->website}" target="_blank">{$store->website}</a>
                                </p>
                            </div>
                        </div>
                    {/if}

                    <div class="row">
                        <label class="control-label col-lg-3">Centrale</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {$clinique->centrale}
                            </p>
                        </div>
                    </div>

                    <div class="row">
                        <label class="control-label col-lg-3">Entrepot</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {$warehouse->name}
                            </p>
                        </div>
                    </div>

                    <div class="row">
                        <label class="control-label col-lg-3">Code client</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {$clinique->code_client}
                            </p>
                        </div>
                    </div>

                    <div class="row">
                        <label class="control-label col-lg-3">Code filière</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {$clinique->code_filiere}
                            </p>
                        </div>
                    </div>

                    <div class="row">
                        <label class="control-label col-lg-3">Thème graphique</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {if $clinique->id_theme}{$clinique->getTheme()->name}{else}Défaut{/if}
                            </p>
                        </div>
                    </div>

                    <div class="row">
                        <label class="control-label col-lg-3">Logo MyVetShop</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {if $clinique->masquer_logo}
                                    <span class="label label-danger">
                                        <i class="icon-remove"></i>
                                        Masqué
                                    </span>
                                {else}
                                    <span class="label label-success">
                                        <i class="icon-check"></i>
                                        Affiché
                                    </span>
                                {/if}
                            </p>
                        </div>
                    </div>

                    <div class="row">
                        <label class="control-label col-lg-3">Factures par email</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {if $clinique->email_factures}
                                    <span class="label label-success">
                                        <i class="icon-check"></i>
                                        Activé
                                    </span>
                                {else}
                                    <span class="label label-danger">
                                        <i class="icon-remove"></i>
                                        Désactivé
                                    </span>
                                {/if}
                            </p>
                        </div>
                    </div>

                    <div class="row">
                        <label class="control-label col-lg-3">Lien personnalisé</label>
                        <div class="col-lg-9 form-control-static">
                            <p>https://www.myvetshop.fr/?theme_privilege={$clinique->id_employee}</p>
                        </div>
                    </div>

                    <div class="row">
                        <label class="control-label col-lg-3">Configuration</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                <span class="label {if $clinique->id_employee}label-success{else}label-danger{/if}">
                                    <i class="icon-check"></i>
                                    Employé
                                </span>
                                &nbsp;
                                <span class="label {if $clinique->id_carrier}label-success{else}label-danger{/if}">
                                    <i class="icon-check"></i>
                                    Livr (cl)
                                </span>
                                &nbsp;
                                <span class="label {if $clinique->id_carrier_home}label-success{else}label-danger{/if}">
                                    <i class="icon-check"></i>
                                    Livr (dm)
                                </span>
                                &nbsp;
                                <span class="label {if $clinique->id_group}label-success{else}label-danger{/if}">
                                    <i class="icon-check"></i>
                                    Groupe client
                                </span>
                                &nbsp;
                                <span class="label {if $group_reduction}label-success{else}label-danger{/if}">
                                    <i class="icon-check"></i>
                                    Tarif privilège
                                </span>
                                &nbsp;
                                <span class="label {if $clinique->id_store}label-success{else}label-danger{/if}">
                                    <i class="icon-check"></i>
                                    Boutique
                                </span>
                            </p>
                        </div>
                    </div>

                    <div class="row">
                        <label class="control-label col-lg-3">Rural</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {if $clinique->rurale}
                                    <span class="label label-success">
                                        <i class="icon-check"></i>
                                        Activée
                                    </span>
                                {else}
                                    <span class="label label-danger">
                                        <i class="icon-remove"></i>
                                        Désactivée
                                    </span>
                                {/if}
                            </p>
                        </div>
                    </div>

                    <div class="row">
                        <label class="control-label col-lg-3">Logo</label>
                        <div class="col-lg-9 form-control-static">
                            {$logo_url}
                        </div>
                    </div>
                    <div class="row">
                        <label class="control-label col-lg-3">Photo de la clinique</label>
                        <div class="col-lg-9 form-control-static">
                            {$photo_url}
                        </div>
                    </div>
                    <div class="row">
                        <label class="control-label col-lg-3">Adresse</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {$store->address1} <br>
                                {if $store->address2}{$store->address2}<br>{/if}
                                {$store->postcode} {$store->city}
                            </p>
                            <p>
                                Coordonnées GPS : {$store->latitude}, {$store->longitude}
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <label class="control-label col-lg-3">Lien prise de rendez-vous</label>
                        <div class="col-lg-9">
                            <p class="form-control-static">
                                <a href="{$clinique->url_rendez_vous}" target="_blank">{$clinique->url_rendez_vous}</a>
                            </p>
                        </div>
                    </div>
                    {if !empty($store->hours)}
                        <div class="row">
                            {assign var=hours value=$store->getWsHours()|json_decode}
                            <label class="control-label col-lg-3">Horaires</label>
                            <div class="col-lg-9 form-control-static">
                                <table class="table">
                                    <tbody>
                                    <tr>
                                        <td><strong>Lundi</strong></td>
                                        <td>{$hours.0.0}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Mardi</strong></td>
                                        <td>{$hours.1.0}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Mercredi</strong></td>
                                        <td>{$hours.2.0}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Jeudi</strong></td>
                                        <td>{$hours.3.0}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Vendredi</strong></td>
                                        <td>{$hours.4.0}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Samedi</strong></td>
                                        <td>{$hours.5.0}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Dimanche</strong></td>
                                        <td>{$hours.6.0}</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    {/if}
                    <div class="row">
                        <label class="control-label col-lg-3">Jours de livraison</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {$clinique->getShipping()->toString()}
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <label class="control-label col-lg-3">Prix livraison à domicile</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {$carrier_home_price|round:2} € HT
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <label class="control-label col-lg-3">Clé API</label>
                        <div class="col-lg-9 form-control-static">
                            <p>
                                {$clinique->apiKey}
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="panel">
                <div class="panel-heading">
                    <i class="icon-file"></i> Vacances <span class="badge">{count($holidays)}</span>
                    <div class="panel-heading-action">
                        <a class="btn btn-default"
                           href="?controller=adminmyvetshopcliniqueholidays&amp;addmyvetshop_clinique_holidays&amp;token={getAdminToken tab='AdminMyVetShopCliniqueHolidays'}&amp;id_myvetshop_clinique={$clinique->id_myvetshop_clinique|intval}">
                            <i class="icon-edit"></i>
                            {l s='Add'}
                        </a>
                    </div>
                </div>
                {if $holidays AND count($holidays)}
                    <table class="table">
                        <thead>
                        <tr>
                            <th class="center"><span class="title_box ">ID</span></th>
                            <th><span class="title_box">Date alerte</span></th>
                            <th><span class="title_box">Date début</span></th>
                            <th><span class="title_box">Date fin</span></th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        {foreach $holidays AS $holiday}
                            <tr>
                                <td>{$holiday->id}</td>
                                <td>{dateFormat date=$holiday->date_alerte full=0}</td>
                                <td>{dateFormat date=$holiday->date_debut full=0}</td>
                                <td>{dateFormat date=$holiday->date_fin full=0}</td>
                                <td>
                                    <a class="btn btn-default"
                                       href="?controller=adminmyvetshopcliniqueholidays&amp;id_myvetshop_clinique_holidays={$holiday->id|intval}&amp;updatemyvetshop_clinique_holidays&amp;token={getAdminToken tab='AdminMyVetShopCliniqueHolidays'}">
                                        <i class='icon-search'></i> {l s='View'}
                                    </a>
                                </td>
                            </tr>
                        {/foreach}
                        </tbody>
                    </table>
                {else}
                    <p class="text-muted text-center">
                        {l s='%1$s n\'a aucune période de vacances pour l\'instant' sprintf=[$clinique->code_privilege]}
                    </p>
                {/if}
            </div>

        </div>
        {*right*}
        <div class="col-lg-6">
            <div class="panel">
                <div class="panel-heading">
                    <i class="icon-file"></i> Dernières commandes <span class="badge">10 / {$order_count}</span>
                </div>
                {if $orders AND count($orders)}
                    <table class="table">
                        <thead>
                        <tr>
                            <th class="center"><span class="title_box ">ID</span></th>
                            <th><span class="title_box">Date</span></th>
                            <th><span class="title_box">Paiement</span></th>
                            <th><span class="title_box">Etat</span></th>
                            <th><span class="title_box">Produits</span></th>
                            <th><span class="title_box ">Total (€)</span></th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        {foreach $orders AS $key => $order}
                            <tr onclick="document.location = '?tab=AdminOrders&amp;id_order={$order->id|intval}&amp;vieworder&amp;token={getAdminToken tab='AdminOrders'}'">
                                <td>{$order->id}</td>
                                <td>{dateFormat date=$order->invoice_date full=0}</td>
                                <td>{$order->payment}</td>
                                <td>{$order->getCurrentOrderState()->name[1]}</td>
                                <td>{$order->getOrderDetailList()|count}</td>
                                <td>{$order->total_paid_real}</td>
                                <td>
                                    <a class="btn btn-default"
                                       href="?tab=AdminOrders&amp;id_order={$order->id|intval}&amp;vieworder&amp;token={getAdminToken tab='AdminOrders'}">
                                        <i class='icon-search'></i> {l s='View'}
                                    </a>
                                </td>
                            </tr>
                        {/foreach}
                        </tbody>
                    </table>
                {else}
                    <p class="text-muted text-center">
                        {l s='%1$s n\'a aucune commande pour l\'instant' sprintf=[$clinique->code_privilege]}
                    </p>
                {/if}
            </div>

            <div class="panel">
                <div class="panel-heading">
                    <i class="icon-user"></i> Clients <span class="badge">10 / {$customer_count}</span>
                    <div class="panel-heading-action">
                        <a class="btn btn-default"
                           href="{$current|escape:'html':'UTF-8'}&amp;exportabandonmyvetshop_clinique&amp;id_myvetshop_clinique={$clinique->id_myvetshop_clinique|intval}&amp;token={$token|escape:'html':'UTF-8'}&amp;back={$smarty.server.REQUEST_URI|urlencode}">
                            Export abandons
                        </a>
                    </div>
                </div>
                {if $customers AND count($customers)}
                    <table class="table">
                        <thead>
                        <tr>
                            <th class="center"><span class="title_box ">ID</span></th>
                            {*<th><span class="title_box">Titre</span></th>*}
                            <th><span class="title_box">Nom</span></th>
                            <th><span class="title_box">Prénom</span></th>
                            <th><span class="title_box">E-mail</span></th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        {foreach $customers AS $key => $customer}
                            <tr onclick="document.location = '?tab=AdminCustomers&amp;id_customer={$customer->id|intval}&amp;viewcustomer&amp;token={getAdminToken tab='AdminCustomers'}'">
                                <td>{$customer->id}</td>
                                {*<td>{$customer->title}</td>*}
                                <td>{$customer->firstname}</td>
                                <td>{$customer->lastname}</td>
                                <td>{$customer->email}</td>
                                <td>
                                    <a class="btn btn-default"
                                       href="?tab=AdminCustomers&amp;id_customer={$customer->id|intval}&amp;viewcustomer&amp;token={getAdminToken tab='AdminCustomers'}">
                                        <i class='icon-search'></i> {l s='View'}
                                    </a>
                                </td>
                            </tr>
                        {/foreach}
                        </tbody>
                    </table>
                {else}
                    <p class="text-muted text-center">
                        {l s='%1$s n\'a aucune commande pour l\'instant' sprintf=[$clinique->code_privilege]}
                    </p>
                {/if}
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-6">

        </div>
        <div class="col-lg-6">
        </div>
    </div>

    <div class="row">
    </div>
</div>
