<?php

namespace Myvetshop\Module\Clinique\Prestashop\Event;

use Myvetshop\Module\Clinique\Security\Profiles\ComptaProfile;
use Myvetshop\Module\Clinique\Security\Profiles\ProfileInterface;
use Myvetshop\Module\Clinique\Security\Profiles\SAVProfile;
use Myvetshop\Module\Clinique\Security\Profiles\VetoProfile;
use PrestaShopBundle\Event\ModuleManagementEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class AfterInstallModuleSubscriber implements EventSubscriberInterface
{
    /**
     * @var list<ProfileInterface>
     */
    private array $profiles;

    public function __construct(
        ComptaProfile $comptaProfile,
        SAVProfile $savProfile,
        VetoProfile $vetoProfile
    ) {
        $this->profiles = [
            $comptaProfile,
            $savProfile,
            $vetoProfile,
        ];
    }

    /**
     * @return array<string, string>
     */
    public static function getSubscribedEvents(): array
    {
        return [
            ModuleManagementEvent::INSTALL => 'onModuleInstall',
        ];
    }

    public function onModuleInstall(ModuleManagementEvent $event): void
    {
        if ($event->getModule()->get('name') !== 'myvetshopclinique') {
            return;
        }

        foreach ($this->profiles as $profile) {
            $profile->ensureProfileIsConfigured();
        }
    }
}
