<?php

namespace Myvetshop\Module\Clinique\Import\Dixptz\Serializer;

use Myvetshop\Module\Clinique\Import\Dixptz\Model\CustomerModel;

class CustomerModelNormalizer extends \Myvetshop\Module\Clinique\Import\Serializer\CustomerModelNormalizer
{
    /**
     * @param array<mixed> $context
     *
     * @return CustomerModel
     */
    public function denormalize($data, $type, $format = null, array $context = [])
    {
        /** @var CustomerModel $ret
         */
        $ret = parent::denormalize($data, $type, $format, ['object' => new CustomerModel()]);

        \assert(\is_array($data));

        $ret->codePrivilege = $data['code_privilege'];

        return $ret;
    }

    public function supportsDenormalization($data, $type, $format = null)
    {
        return CustomerModel::class === $type;
    }
}
