<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_myvetshop_clinique_shipping")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\MyvetshopCliniqueShippingRepository")
 */
class MyvetshopCliniqueShipping
{
    /**
     * @ORM\Id()
     *
     * @ORM\Column(name="id_myvetshop_clinique_shipping", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\OneToOne(targetEntity="Myvetshop\Module\Clinique\Entity\MyvetshopClinique", inversedBy="shipping")
     *
     * @ORM\JoinColumn(name="id_myvetshop_clinique", referencedColumnName="id_myvetshop_clinique", nullable=false)
     */
    public MyvetshopClinique $clinique;

    /**
     * @ORM\Column(type="boolean", nullable=false)
     */
    public bool $monday;

    /**
     * @ORM\Column(type="boolean", nullable=false)
     */
    public bool $tuesday;

    /**
     * @ORM\Column(type="boolean", nullable=false)
     */
    public bool $wednesday;

    /**
     * @ORM\Column(type="boolean", nullable=false)
     */
    public bool $thursday;

    /**
     * @ORM\Column(type="boolean", nullable=false)
     */
    public bool $friday;

    /**
     * @ORM\Column(type="boolean", nullable=false)
     */
    public bool $saturday;

    /**
     * @ORM\Column(type="boolean", nullable=false)
     */
    public bool $sunday;
}
