<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_clinique_push")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\CliniquePushRepository")
 *
 * @ORM\HasLifecycleCallbacks()
 */
class CliniquePush
{
    /**
     * @ORM\Id()
     *
     * @ORM\Column(name="id_clinique_push", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\Column(name="push_id", type="string", length=255, nullable=false)
     */
    public string $pushId;

    /**
     * @ORM\Column(name="push_type", type="string", length=10, nullable=false)
     */
    public string $pushType;

    /**
     * @ORM\Column(name="id_oauth_access_token", type="integer", nullable=true)
     */
    public ?int $idOauthAccessToken = null;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_add", nullable=false)
     */
    protected ?\DateTimeImmutable $dateAdd = null;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_upd", nullable=false)
     */
    protected ?\DateTimeImmutable $dateUpd = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDateAdd(): ?\DateTimeImmutable
    {
        return $this->dateAdd;
    }

    public function getDateUpd(): ?\DateTimeImmutable
    {
        return $this->dateUpd;
    }
}
