<?php

namespace Myvetshop\Module\Clinique\Cart\Preventer\Factory;

use Myvetshop\Module\Clinique\Cart\Preventer\BlockedProductPreventer;
use Myvetshop\Module\Clinique\Repository\MyvetshopCliniqueRepository;

class BlockedProductPreventerFactory
{
    protected MyvetshopCliniqueRepository $cliniqueRepository;

    public function __construct(MyvetshopCliniqueRepository $cliniqueRepository)
    {
        $this->cliniqueRepository = $cliniqueRepository;
    }

    public function create(): BlockedProductPreventer
    {
        return new BlockedProductPreventer(
            $this->cliniqueRepository,
            \strval(
                \Configuration::get('MVS_CLINIQUE_BLOCKED_PRODUCT_MESSAGE') ?: 'Blocked by your clinic'
            ),
        );
    }
}
