<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Shipping;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\OrderInvoiceLineProviderInterface;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\OrderSlipLineProviderInterface;
use Myvetshop\Module\Clinique\Accounting\Export\Model\SimpleAccountingLine;

class ShippingProvider implements OrderInvoiceLineProviderInterface, OrderSlipLineProviderInterface
{
    public function getInvoiceAccountingLines(\OrderInvoice $orderInvoice, \Order $order): array
    {
        $ret = [];

        if ($orderInvoice->total_shipping_tax_excl > 0) {
            $ret[] = new SimpleAccountingLine(
                '708004',
                \round($orderInvoice->total_shipping_tax_excl, 2),
                0.00,
            );
        }

        return $ret;
    }

    public function getSlipAccountingLines(\OrderSlip $orderSlip, \Order $order): array
    {
        $ret = [];

        if ($orderSlip->total_shipping_tax_excl > 0) {
            $ret[] = new SimpleAccountingLine(
                '708004',
                0.00,
                \round($orderSlip->total_shipping_tax_excl, 2),
            );
        }

        return $ret;
    }

    /**
     * @param \OrderInvoice|\OrderSlip $document
     */
    public function getAccountingLines($document, \Order $order): array
    {
        return $document instanceof \OrderInvoice
            ? $this->getInvoiceAccountingLines($document, $order)
            : $this->getSlipAccountingLines($document, $order);
    }
}
