<?php

namespace App\Tests\A_Unit\Accounting\Export\Repository;

use Myvetshop\Module\Clinique\Accounting\Export\Repository\OrderInvoiceTaxRepository;
use PHPUnit\Framework\TestCase;

class OrderInvoiceTaxRepositoryTest extends TestCase
{
    public function testGetByOrderInvoice(): void
    {
        $db = $this->getMockBuilder(\Db::class)
            ->disableOriginalConstructor()
            ->getMock();

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();
        $order->id = 1;

        $repository = new OrderInvoiceTaxRepository($db);

        $db
            ->method('executeS')
            ->with('SELECT oi.id_order_invoice, oit.type, oit.amount, t.rate'
                . ' FROM `pstest_order_invoice` oi'
                . ' INNER JOIN `pstest_order_invoice_tax` oit ON oit.id_order_invoice = oi. id_order_invoice'
                . ' INNER JOIN `pstest_tax` t ON t.id_tax = oit.id_tax'
                . ' WHERE oi.id_order IN (1)')
            ->willReturn([
                [
                    'id_order_invoice' => 5,
                    'type' => 'shipping',
                    'amount' => '11.080000',
                    'rate' => '20.000',
                ],
            ]);

        // Preload objects
        $repository->preload([$order]);

        $orderInvoice = $this->getMockBuilder(\OrderInvoice::class)
            ->disableOriginalConstructor()
            ->getMock();
        $orderInvoice->id = 5;

        $taxes = $repository->getByOrderInvoice($orderInvoice);

        self::assertCount(1, $taxes);
        self::assertEquals('shipping', $taxes[0]['type']);
        self::assertEquals(11.08, $taxes[0]['amount']);
        self::assertEquals(20, $taxes[0]['rate']);
    }
}
