<?php

namespace Myvetshop\Module\Clinique\Adapter;

use Psr\Log\LoggerInterface;

class PrestashopLoggerAdapter implements LoggerInterface
{
    public function emergency($message, array $context = [])
    {
        if (!\is_string($message)) {
            return;
        }

        \PrestaShopLogger::addLog(
            $message . ($context['stackTrace'] ? "\n" . $context['stackTrace'] : ''),
            4,
            \is_int($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_string($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    public function alert($message, array $context = [])
    {
        \PrestaShopLogger::addLog(
            $message . ($context['stackTrace'] ? "\n" . $context['stackTrace'] : ''),
            4,
            \is_int($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_string($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    public function critical($message, array $context = [])
    {
        \PrestaShopLogger::addLog(
            $message . ($context['stackTrace'] ? "\n" . $context['stackTrace'] : ''),
            4,
            \is_int($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_string($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    public function error($message, array $context = [])
    {
        \PrestaShopLogger::addLog(
            $message . ($context['stackTrace'] ? "\n" . $context['stackTrace'] : ''),
            3,
            \is_int($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_string($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    public function warning($message, array $context = [])
    {
        \PrestaShopLogger::addLog(
            $message . ($context['stackTrace'] ? "\n" . $context['stackTrace'] : ''),
            2,
            \is_int($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_string($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    public function notice($message, array $context = [])
    {
        \PrestaShopLogger::addLog(
            $message . ($context['stackTrace'] ? "\n" . $context['stackTrace'] : ''),
            1,
            \is_int($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_string($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    public function info($message, array $context = [])
    {
        \PrestaShopLogger::addLog(
            $message . ($context['stackTrace'] ? "\n" . $context['stackTrace'] : ''),
            1,
            \is_int($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_string($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    public function debug($message, array $context = [])
    {
    }

    public function log($level, $message, array $context = [])
    {
        if (!\is_int($level)) {
            return;
        }

        \PrestaShopLogger::addLog(
            $message . ($context['stackTrace'] ? "\n" . $context['stackTrace'] : ''),
            $level,
            \is_int($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_string($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }
}
