<?php

namespace App\Tests\Stub\Smarty;

class SmartyModuleResource extends \Smarty_Resource_Custom
{
    private string $moduleDirectory;

    public function __construct(string $moduleDirectory)
    {
        $this->moduleDirectory = $moduleDirectory;
    }

    protected function fetch($name, &$source, &$mtime): void
    {
        if (\strpos($name, 'myvetshopclinique') === 0) {
            $filename = $this->moduleDirectory . '/' . $name;

            $source = \file_get_contents($filename);
            $mtime = \filemtime($filename);
        } else {
            throw new \Exception($name);
        }
    }
}
