<?php

namespace App\Tests;

use Symfony\Component\Config\Loader\LoaderInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Kernel;

class PhpunitKernel extends Kernel
{
    public function getProjectDir(): string
    {
        return \dirname(__FILE__) . '/..';
    }

    public function getCacheDir()
    {
        return $this->getProjectDir() . '/var/cache/' . $this->environment;
    }

    /**
     * {@inheritdoc}
     */
    public function getLogDir()
    {
        return $this->getProjectDir() . '/var/log';
    }

    public function registerBundles(): iterable
    {
        return [
            new \Symfony\Bundle\FrameworkBundle\FrameworkBundle(),
            new \Symfony\Bundle\TwigBundle\TwigBundle(),
            new \Doctrine\Bundle\DoctrineBundle\DoctrineBundle(),
        ];
    }

    public function registerContainerConfiguration(LoaderInterface $loader): void
    {
        $loader->load(function (ContainerBuilder $container) {
            $container->setParameter('container.autowiring.strict_mode', true);
            $container->setParameter('container.dumper.inline_class_loader', false);
            $container->setParameter('database_host', null);
            $container->setParameter('database_port', null);
            $container->setParameter('database_name', null);
            $container->setParameter('database_user', null);
            $container->setParameter('database_password', null);
            $container->setParameter('kernel.secret', 'secret');
            $container->addObjectResource($this);
        });

        $loader->load(\dirname(__FILE__) . '/../../prestashop/app/config/doctrine.yml');
        $loader->load(\dirname(__FILE__) . '/config.yml');
        $loader->load(\dirname(__FILE__) . '/../myvetshopclinique/config/front/services.yml');
    }
}
