<?php

namespace Myvetshop\Module\Clinique\Presenter;

use PrestaShop\PrestaShop\Adapter\LegacyContext;

class ProductPresenter
{
    private LegacyContext $legacyContext;

    public function __construct(LegacyContext $legacyContext)
    {
        $this->legacyContext = $legacyContext;
    }

    /**
     * @param \Product $product
     *
     * @return array{id: int, name: string, link: string, images: array<string, list<string>>}
     */
    public function present(\Product $product)
    {
        $context = $this->legacyContext->getContext();

        \assert(null !== $context);

        $images = $product->getImages($context->language->id);
        $images_urls = [
            'cart_default' => [],
            'home_default' => [],
            'large_default' => [],
        ];

        foreach ($images as $image) {
            foreach ($images_urls as $size => $values) {
                $images_urls[$size][] = (new \Link('https://', 'https://'))
                    ->getImageLink($product->link_rewrite[$context->language->id], $image['id_image'], $size);
            }
        }

        return [
            'id' => (int) $product->id,
            'name' => $product->name[$context->language->id],
            'link' => $product->getLink($context),
            'images' => $images_urls,
        ];
    }
}
