<?php

namespace App\Tests\A_Unit\Accounting\Export\Exporter;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\OrderSlipExporterFactory;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\PostProcess\VatRoundCorrectorPostProcessor;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Discount\DiscountProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Product\ProductProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Refund\RefundProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Shipping\ShippingProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Vat\VatProvider;

/**
 * @extends AbstractDocumentExporterTest<\OrderSlip>
 */
abstract class AbstractOrderSlipExporterTest extends AbstractDocumentExporterTest
{
    protected function setUp(): void
    {
        parent::setUp();

        $refundProvider = new RefundProvider();
        $discountProvider = new DiscountProvider();
        $vatProvider = new VatProvider(
            $this->orderDetailTaxRepository,
            $this->orderInvoiceTaxRepository,
            $this->orderSlipDetailRepository
        );
        $productProvider = new ProductProvider(
            $this->countryRepository,
            $this->invoiceAddressRepository,
            $this->orderDetailRepository,
            $this->orderDetailTaxRepository,
            $this->orderSlipDetailRepository
        );
        $shippingProvider = new ShippingProvider();

        $vatPostProcessor = new VatRoundCorrectorPostProcessor();

        $factory = new OrderSlipExporterFactory(
            $this->orderPaymentRepository,
            $refundProvider,
            $discountProvider,
            $vatProvider,
            $productProvider,
            $shippingProvider,
            $vatPostProcessor
        );

        $this->exporter = $factory->create();
    }
}
