<?php

namespace Myvetshop\Module\Clinique\Serializer\Normalizer\Admin;

use Myvetshop\Module\Clinique\Entity\Recommandation;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class RecommandationNormalizer implements NormalizerInterface
{
    /**
     * @param Recommandation $object
     * @param ?string $format
     * @param array<mixed> $context
     *
     * @return array<string, string|int|bool|float|null>
     */
    public function normalize($object, $format = null, array $context = [])
    {
        return [
            'id' => $object->getId() ?? null,
            'id_animal' => $object->animal->getId() ?? null,
            'code_reco' => $object->codeReco,
            'date_reco' => $object->dateReco->format('Y-m-d'),
            'petname' => $object->animal->nom,
            'espece' => $object->espece,
            'race' => $object->race,
            'id_gender' => $object->idGender,
            'activite' => $object->activite,
            'age' => $object->age,
            'stade_physio' => $object->stadePhysio,
            'pathologie' => $object->pathologie,
            'poids_actuel' => $object->poidsActuel,
            'poids_ideal' => $object->poidsIdeal,
            'be' => $object->be,
            'nbr_aliment' => $object->nbrAliment,
            'product_id_mvs1' => $object->productIdMvs1,
            'product_id_mvs2' => $object->productIdMvs2,
            'product_id_mvs3' => $object->productIdMvs3,
            'qte_aliment1' => $object->qteAliment1,
            'qte_aliment2' => $object->qteAliment2,
            'qte_aliment3' => $object->qteAliment3,
            'transition12' => $object->transition12,
            'transition23' => $object->transition23,
            'date_add' => $object->getDateAdd()->format('Y-m-d'),
            'date_upd' => $object->getDateUpd()->format('Y-m-d'),
            'discount_code' => null,
        ];
    }

    public function supportsNormalization($data, $format = null)
    {
        return $data instanceof Recommandation;
    }
}
