<?php

namespace App\Tests\B_Functionnal;

use PHPUnit\Framework\MockObject\MockObject;
use PrestaShop\PrestaShop\Adapter\LegacyContext;
use PrestaShop\PrestaShop\Core\Addon\Theme\Theme;
use PrestaShop\PrestaShop\Core\Foundation\IoC\Container;
use PrestaShopBundle\Translation\TranslatorComponent;
use Symfony\Bundle\FrameworkBundle\Test\KernelTestCase;
use Symfony\Component\HttpFoundation\Request;

abstract class AbstractFrontControllerTestCase extends KernelTestCase
{
    /**
     * @var \Context&MockObject
     */
    protected \Context $context;

    /**
     * @var \Db&MockObject
     */
    protected \Db $db;

    protected function setUp(): void
    {
        parent::setUp();

        $this->db = $this->createMock(\Db::class);
        \Db::setInstanceForTesting($this->db);

        self::bootKernel();

        // Mock dispatcher
        \Dispatcher::$instance = $this->createMock(\Dispatcher::class);

        // Mock module
        $module = $this->createMock(\Module::class);
        $module->active = true;
        $container = $this->createMock(Container::class);

        $container
            ->method('make')
            ->with('myvetshopclinique')
            ->willReturn($module);

        \PrestaShop\PrestaShop\Adapter\ServiceLocator::setServiceContainerInstance($container);

        // Mock request
        $request = new Request();
        $request->request->set('module', 'myvetshopclinique');
        new \Tools($request);

        // Mock Context
        $this->context = $this->createMock(\Context::class);
        $this->context->cart = $this->createMock(\Cart::class);
        $this->context->cookie = $this->createMock(\Cookie::class);
        $this->context->country = $this->createMock(\Country::class);
        $this->context->customer = $this->createMock(\Customer::class);
        $this->context->customer
            ->method('getSimpleAddresses')
            ->willReturn([]);
        $this->context->currency = $this->createMock(\Currency::class);
        $this->context->language = $this->createMock(\Language::class);
        $this->context->language->locale = 'fr';
        $this->context->link = $this->createMock(\Link::class);
        $this->context->shop = $this->createMock(\Shop::class);
        $this->context->shop
            ->method('getAddress')
            ->willReturn($this->createMock(\Address::class));
        $this->context->shop->domain = 'www.myvetshop.fr';
        $this->context->shop->domain_ssl = 'www.myvetshop.fr';
        $this->context->shop->physical_uri = '/';
        $this->context->shop->theme = $this->createMock(Theme::class);

        $translator = $this->createMock(TranslatorComponent::class);
        $translator->method('trans')
            ->willReturnCallback(function ($id) { return $id; });
        $this->context->method('getTranslator')
            ->willReturn($translator);
        $smarty = self::$kernel->getContainer()->get('prestashop.smarty');
        \assert($smarty instanceof \Smarty);
        $this->context->smarty = $smarty;

        \Context::setInstanceForTesting($this->context);
        LegacyContext::setInstanceForTesting($this->context);

        $_SERVER['REQUEST_URI'] = '/';
        $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
    }

    /**
     * @return array<mixed>
     */
    public function getTemplateVarCustomer(): array
    {
        return [
            'id' => $this->context->customer->id,
            'is_logged' => $this->context->customer->isLogged(),
        ];
    }
}
