<?php

namespace App\Tests\A_Unit\Entity\Factory;

use Myvetshop\Module\Clinique\Api\Crokit\Dto\CrokitRecommandation;
use Myvetshop\Module\Clinique\Entity\Animal;
use Myvetshop\Module\Clinique\Entity\Factory\RecommandationFactory;
use PHPUnit\Framework\TestCase;

/**
 * Test class for RecommandationFactory. Tests the method `fromDto`.
 */
class RecommandationFactoryTest extends TestCase
{
    /** @var RecommandationFactory */
    private $factory;

    protected function setUp(): void
    {
        // Instantiate the factory object before each test
        $this->factory = new RecommandationFactory();
    }

    public function testFromDto(): void
    {
        // Set up mock objects
        $animalMock = $this->createMock(Animal::class);
        $animalMock->idCustomer = 1;

        $crokitData = new CrokitRecommandation();
        $crokitData->date = new \DateTimeImmutable();
        $crokitData->codeReco = 'reco123';
        $crokitData->code = 'code987';
        $crokitData->petname = 'petname123';
        $crokitData->esp = 'esp123';
        $crokitData->race = 'race123';
        $crokitData->sex = 'male';
        $crokitData->act = 'act123';
        $crokitData->dob = 'dob123';
        $crokitData->stadePhysio = 'stadePhysio123';
        $crokitData->patho = 'patho123';
        $crokitData->actualw = 2.3;
        $crokitData->idealw = 1.9;
        $crokitData->be = 2;
        $crokitData->nbrAliment = 4;
        $crokitData->productIDmvs1 = 1;
        $crokitData->productIDmvs2 = 2;
        $crokitData->productIDmvs3 = 3;
        $crokitData->qteAliment1 = 75;
        $crokitData->qteAliment2 = 80;
        $crokitData->qteAliment3 = 85;
        $crokitData->transition12 = 75;
        $crokitData->transition23 = 85;

        // Apply factory method
        $result = $this->factory->fromDto($animalMock, $crokitData);

        // Check resulting object
        $this->assertSame($animalMock->idCustomer, $result->idCustomer);
        $this->assertSame($animalMock, $result->animal);
        $this->assertSame($crokitData->codeReco, $result->codeReco);
        $this->assertSame($crokitData->date, $result->dateReco);
        $this->assertSame($crokitData->code, $result->codeClinique);
        // ... other assertions ...
    }
}
