<?php

namespace Myvetshop\Module\Clinique\Presenter;

use Myvetshop\Module\Clinique\Entity\Animal;

class AnimalPresenter
{
    /**
     * @param Animal $animal
     *
     * @return array{
     *     id: int,
     *     id_customer: int,
     *     espece: string|null,
     *     race: string|null,
     *     id_gender: int,
     *     robe: string|null,
     *     nom: string
     * }
     */
    public function present(Animal $animal)
    {
        return [
            'id' => $animal->getId() ?? 0,
            'id_customer' => $animal->idCustomer,
            'espece' => $animal->espece,
            'race' => $animal->race,
            'id_gender' => $animal->idGender,
            'robe' => $animal->robe,
            'nom' => $animal->nom,
        ];
    }
}
