<?php

namespace Myvetshop\Module\Clinique\Cart;

use Myvetshop\Module\Clinique\Cart\Preventer\AddToCartPreventerInterface;

/**
 * Prevent prestashop to add to cart some products
 */
class ProductAddToCartPreventer
{
    /**
     * @var iterable<AddToCartPreventerInterface>
     */
    protected iterable $preventers;

    /**
     * @param iterable<AddToCartPreventerInterface> $preventers
     */
    public function __construct(
        iterable $preventers
    ) {
        $this->preventers = $preventers;
    }

    /**
     * @param \Product $product target product of the operation
     * @param int $qty Number to add / remove
     * @param string $operation up|down
     */
    public function getErrorMessage(
        \Product $product,
        int $idProductAttribute,
        int $qty,
        string $operation,
        \Customer $customer,
        \Cart $cart
    ): ?string {
        // Always allow down operations
        if ($operation != 'up') {
            return null;
        }

        foreach ($this->preventers as $preventer) {
            $message = $preventer->getErrorMessage($product, $idProductAttribute, $qty, $operation, $customer, $cart);
            if (null !== $message) {
                return $message;
            }
        }

        return null;
    }
}
