<?php

declare(strict_types=1);

class WebserviceSpecificManagementOrderReturnStates implements WebserviceSpecificManagementInterface
{
    /** @var WebserviceOutputBuilderCore|null */
    protected $objOutput;
    /** @var mixed */
    protected $output;

    /** @var WebserviceRequestCore|null */
    protected $wsObject;

    public function setObjectOutput(WebserviceOutputBuilderCore $obj): self
    {
        $this->objOutput = $obj;

        return $this;
    }

    public function getObjectOutput(): ?WebserviceOutputBuilderCore
    {
        return $this->objOutput;
    }

    public function setWsObject(WebserviceRequestCore $obj): self
    {
        $this->wsObject = $obj;

        return $this;
    }

    public function getWsObject(): ?WebserviceRequestCore
    {
        return $this->wsObject;
    }

    public function manage(): void
    {
        $db = Db::getInstance();

        $orderReturnStates = $db->executeS(
            'SELECT `ors`.*, `orsl`.`name` FROM `ps_order_return_state` `ors`
                INNER JOIN `ps_order_return_state_lang` `orsl` ON `orsl`.`id_order_return_state` = `ors`.`id_order_return_state` AND `orsl`.`id_lang` = 1
                ORDER BY `ors`.`id_order_return_state` ASC'
        );

        header('Content-Type: application/json');
        echo json_encode(['order_return_states' => $orderReturnStates]);
        exit;
    }

    /**
     * This must be return an array with specific values as WebserviceRequest expects.
     *
     * @return array<mixed>|string
     */
    public function getContent()
    {
        if (!$this->objOutput) {
            return [];
        }

        return $this->objOutput->getObjectRender()->overrideContent($this->output);
    }
}
