<?php

namespace Myvetshop\Module\Clinique\Import\Dixptz\Clinic;

use Myvetshop\Module\Clinique\Import\Dixptz\Model\ClinicModel;

class ClinicImportFileProvider
{
    /**
     * @var list<ClinicModel>
     */
    protected ?array $clinics = null;

    /**
     * @return resource
     */
    public function open()
    {
        $ret = \fopen('/tmp/cliniques.csv', 'r');

        if (!$ret) {
            throw new \Exception("Can't open /tmp/cliniques.csv file");
        }

        return $ret;
    }

    /**
     * @return list<ClinicModel>
     */
    public function getClinics(?string $code): array
    {
        if (null === $this->clinics) {
            $csv = $this->open();

            // Skip header line
            \fgetcsv($csv, 0, ';');

            $header = [
                'code_privilege',
                'centrale',
                'code_coveto',
                'nom_10ptz',
                'nom_myvetshop',
                'adresse1',
                'adresse2',
                'code_postal',
                'ville',
                'latitude',
                'longitude',
                'email',
                'site_internet',
                'livraison_lundi',
                'livraison_mardi',
                'livraison_mercredi',
                'livraison_jeudi',
                'livraison_vendredi',
                'livraison_samedi',
                'phone',
                'siret',
                'rcs',
                'tva',
                'hours',
            ];

            $this->clinics = [];

            while ($line = \fgetcsv($csv, 0, ';')) {
                $row = \array_combine($header, $line);

                \assert(false !== $row);

                $model = new ClinicModel();
                $model->codePrivilege = $row['code_privilege'] ?? '';
                $model->centrale = $row['centrale'] ?? '';
                $model->codeCoveto = $row['code_coveto'] ?? '';
                $model->nom10ptz = $row['nom_10ptz'] ?? '';
                $model->nomMyvetshop = $row['nom_myvetshop'] ?? '';
                $model->adresse1 = $row['adresse1'] ?? '';
                $model->adresse2 = $row['adresse2'] ?? '';
                $model->codePostal = $row['code_postal'] ?? '';
                $model->ville = $row['ville'] ?? '';
                $model->latitude = $row['latitude'] ?? '';
                $model->longitude = $row['longitude'] ?? '';
                $model->email = $row['email'] ?? '';
                $model->siteInternet = $row['site_internet'] ?? '';
                $hours = \unserialize($row['hours'] ?? '');
                if (\is_array($hours)) {
                    $model->hours = $hours;
                }
                $model->livraisonLundi = !empty($row['livraison_lundi']);
                $model->livraisonMardi = !empty($row['livraison_mardi']);
                $model->livraisonMercredi = !empty($row['livraison_mercredi']);
                $model->livraisonJeudi = !empty($row['livraison_jeudi']);
                $model->livraisonVendredi = !empty($row['livraison_vendredi']);
                $model->livraisonSamedi = !empty($row['livraison_samedi']);

                if (empty($model->codePrivilege)) {
                    continue;
                }
                // If only ONE code is asked, return only this code !
                if ($code && $model->codePrivilege !== $code) {
                    continue;
                }

                $this->clinics[] = $model;
            }

            \fclose($csv);
        }

        return $this->clinics;
    }
}
