<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_myvetshop_export_product")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\MyvetshopExportProductRepository")
 *
 * @ORM\HasLifecycleCallbacks()
 */
class MyvetshopExportProduct
{
    /**
     * @ORM\Id()
     *
     * @ORM\Column(name="id_export_product", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\ManyToOne(targetEntity="Myvetshop\Module\Clinique\Entity\MyvetshopClinique", inversedBy="exportProducts")
     *
     * @ORM\JoinColumn(name="id_myvetshop_clinique", referencedColumnName="id_myvetshop_clinique", nullable=false)
     */
    public MyvetshopClinique $clinique;

    /**
     * @ORM\Column(type="string", length=50, nullable=false)
     */
    public string $name;

    /**
     * @ORM\Column(type="date_immutable", name="date_start", nullable=false)
     */
    public \DateTimeImmutable $dateStart;

    /**
     * @ORM\Column(type="date_immutable", name="date_end", nullable=false)
     */
    public \DateTimeImmutable $dateEnd;

    /**
     * @ORM\Column(type="text", name="products", nullable=false)
     */
    public string $products;

    /** @var string */
    public $filters;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_add", nullable=false)
     */
    protected ?\DateTimeImmutable $dateAdd = null;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_upd", nullable=false)
     */
    protected ?\DateTimeImmutable $dateUpd = null;

    /** @var bool */
    public $execute;

    /**
     * @ORM\Column(type="boolean", name="deleted", nullable=false)
     */
    public bool $deleted = false;

    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @ORM\PrePersist()
     */
    public function prePersist(): void
    {
        $this->dateAdd = new \DateTimeImmutable();
        $this->dateUpd = new \DateTimeImmutable();
    }

    /**
     * @ORM\PreUpdate()
     */
    public function preUpdate(): void
    {
        $this->dateUpd = new \DateTimeImmutable();
    }
}
