<?php

namespace Myvetshop\Module\Clinique\Import\Sync\Syncer;

use Myvetshop\Module\Clinique\Import\Model\CustomerModel;
use Myvetshop\Module\Clinique\Import\Sync\SyncStatistics;

class CustomerSyncer
{
    protected function createCustomer(): \Customer
    {
        return new \Customer();
    }

    public function getCustomer(CustomerModel $customerModel): ?\Customer
    {
        $customers = \ObjectModel::hydrateCollection(
            \Customer::class,
            \Customer::getCustomersByEmail($customerModel->email),
        );

        if (\count($customers) > 1) {
            throw new \Exception('Too much customers with the same email : ' . $customerModel->email);
        }

        return $customers[0] ?? null;
    }

    public function sync(
        SyncStatistics $syncStatistics,
        \Clinique $clinique,
        CustomerModel $customerModel
    ): \Customer {
        $customer = $this->getCustomer($customerModel);

        if (!$customer) {
            ++$syncStatistics->nbCustomersCreated;
            $customer = $this->createCustomer();
            $customer->id_shop_group = 1;
            $customer->id_shop = 1;
            $customer->id_gender = $customerModel->idGender;
            $customer->id_default_group = 3;
            $customer->id_lang = 1;
            $customer->id_risk = 0;
            $customer->company = $customerModel->company ?? '';
            $customer->siret = $customerModel->siret ?? '';
            $customer->ape = $customerModel->ape ?? '';
            $customer->firstname = $customerModel->firstname;
            $customer->lastname = \str_replace('/', '-', $customerModel->lastname);
            $customer->email = $customerModel->email;
            $customer->passwd = $customerModel->passwd;
            $customer->last_passwd_gen = $customerModel->lastPasswdGen
                ? $customerModel->lastPasswdGen->format('Y-m-d H:i:s')
                : '';
            $customer->birthday = $customerModel->birthday;
            // Patch invalid birthday
            if (
                $customer->birthday !== '0000-00-00'
                && (
                    !\in_array(\substr($customer->birthday, 0, 2), ['19', '20'])
                    || \intval(\substr($customer->birthday, 0, 4)) > 2024
                )
            ) {
                $customer->birthday = '0000-00-00';
            }
            $customer->newsletter = $customerModel->newsletter;
            $customer->ip_registration_newsletter = $customerModel->ipRegistrationNewsletter ?? '';
            $customer->newsletter_date_add = $customerModel->newsletterDateAdd ?
                $customerModel->newsletterDateAdd->format('Y-m-d H:i:s')
                : '';
            $customer->optin = $customerModel->optin;
            $customer->website = $customerModel->website ?? '';
            $customer->outstanding_allow_amount = 0.000000;
            $customer->show_public_prices = 0;
            $customer->max_payment_days = 60;
            $customer->secure_key = $customerModel->secureKey;
            $customer->note = $customerModel->note ?? '';
            $customer->active = $customerModel->active;
            $customer->is_guest = false;
            $customer->deleted = $customerModel->deleted;
            $customer->date_add = $customerModel->dateAdd->format('Y-m-d H:i:s');
            $customer->date_upd = $customerModel->dateUpd->format('Y-m-d H:i:s');

            $customer->save(false, false);
        } else {
            ++$syncStatistics->nbCustomersUpdated;
        }

        if ((int) $customer->id_default_group === 3) {
            $customer->id_default_group = $clinique->id_group;
            $customer->save();
        }

        $groups = $customer->getGroups();
        if (!\is_array($groups) || !\in_array((int) $clinique->id_group, $groups)) {
            $customer->addGroups([$clinique->id_group]);
        }

        return $customer;
    }
}
