{extends 'page.tpl'}

{block name='page_title'}
    {l s='Mes recommandations' d='Modules.Myvetshopclinique.Shop'}
{/block}

{block name='page_content_top'}

{/block}

{block name='page_content'}
    <div class="block-center">
        <div class="box">
            {if isset($recommandation)}
                <h2>Recommandation nutritionnelle personnalisée pour
                    votre {$recommandation.espece} {$recommandation.animal.nom}</h2>
                <p>
                    <span class="bold"><a class="text-orange"
                                          href="{$link->getPageLink('my-account', true)|escape:'html'}">Identifiez-vous</a> dès aujourd'hui sur Myvetshop pour commander vos aliments et bénéficier d'une remise supplémentaire de 5%.</span>
                    <br>
                    Rappel du code privilège de votre clinique : <span
                            class="text-orange bold">{$recommandation.codeReco}</span> (à renseigner lors de votre
                    inscription)
                </p>
                <br>
                <div class="d-flex justify-content-center">
                    <a href="{$link->getPageLink('my-account', true)|escape:'html'}"
                       class="btn btn btn-primary">
                        <span>M'identifier</span>
                    </a>
                </div>
            {else}
                <h2>Code recommandation invalide</h2>
                <p>
                    <span class="bold">
                        <a class="text-orange" href="{$link->getPageLink('my-account', true)|escape:'html'}">
                            Identifiez-vous
                        </a>
                    </span>
                    <br>
                    Votre code recommandation n'est plus disponible. Réessayez dans quelques minutes puis contactez
                    votre vétérinaire pour plus d'information.
                </p>
            {/if}
        </div>
    </div>
{/block}

{block name='page_footer'}

{/block}
