<?php

namespace Myvetshop\Module\Clinique\Import\Serializer;

use Myvetshop\Module\Clinique\Import\Model\AddressModel;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

class AddressModelNormalizer implements DenormalizerInterface
{
    /**
     * @param array<mixed> $context
     *
     * @return AddressModel
     */
    public function denormalize($data, $type, $format = null, array $context = [])
    {
        if (!\is_array($data)) {
            throw new \Exception('Invalid JSON data');
        }

        $ret = new AddressModel();

        $ret->email = $data['email'];
        $ret->idAddress = \intval($data['id_address']);
        $ret->idCountry = \intval($data['id_country']);
        $ret->idState = \intval($data['id_state']);
        $ret->idCustomer = \intval($data['id_customer']);
        $ret->alias = $data['alias'];
        $ret->company = $data['company'];
        $ret->lastname = $data['lastname'];
        $ret->firstname = $data['firstname'];
        $ret->address1 = $data['address1'];
        $ret->address2 = $data['address2'];
        $ret->postcode = $data['postcode'];
        $ret->city = $data['city'];
        $ret->other = $data['other'];
        $ret->phone = $data['phone'];
        $ret->phoneMobile = $data['phone_mobile'];
        $ret->vatNumber = $data['vat_number'];
        $ret->dni = $data['dni'];
        $ret->dateAdd = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['date_add'])
            ?: new \DateTimeImmutable();
        $ret->dateUpd = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['date_upd'])
            ?: new \DateTimeImmutable();

        return $ret;
    }

    public function supportsDenormalization($data, $type, $format = null)
    {
        return AddressModel::class === $type;
    }
}
