<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_animal")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\AnimalRepository")
 *
 * @ORM\HasLifecycleCallbacks()
 */
class Animal
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(type="integer", name="id_animal", nullable=false)
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\Column(type="integer", name="id_customer", nullable=false)
     */
    public int $idCustomer;

    /**
     * @ORM\Column(type="string", length=50, name="espece", nullable=true)
     */
    public ?string $espece = null;

    /**
     * @ORM\Column(type="string", length=100, name="nom", nullable=false)
     */
    public string $nom;

    /**
     * @ORM\Column(type="string", length=255, name="race", nullable=true)
     */
    public ?string $race = null;

    /**
     * @ORM\Column(type="integer", name="id_gender", nullable=false)
     */
    public int $idGender;

    /**
     * @ORM\Column(type="string", length=100, name="robe", nullable=true)
     */
    public ?string $robe = null;

    /**
     * @ORM\Column(type="date_immutable", name="date_naissance", nullable=true)
     */
    public ?\DateTimeImmutable $dateNaissance = null;

    /**
     * @ORM\Column(type="integer", name="ration", nullable=false)
     */
    public int $ration;

    /**
     * @ORM\Column(type="integer", name="id_product", nullable=false)
     */
    public int $idProduct;

    /**
     * @ORM\Column(type="integer", name="id_product_attribute", nullable=false)
     */
    public int $idProductAttribute;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_add", nullable=false)
     */
    protected ?\DateTimeImmutable $dateAdd = null;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_upd", nullable=false)
     */
    protected ?\DateTimeImmutable $dateUpd = null;

    /**
     * @ORM\Column(type="boolean", name="deleted", nullable=false)
     */
    public bool $deleted = false;

    /**
     * @ORM\OneToMany(targetEntity="Myvetshop\Module\Clinique\Entity\Recommandation", mappedBy="animal")
     *
     * @var Collection<int, Recommandation>
     */
    protected Collection $recommandations;

    /**
     * @ORM\OneToMany(targetEntity="Myvetshop\Module\Clinique\Entity\AnimalSac", mappedBy="animal")
     *
     * @var Collection<int, AnimalSac>
     */
    protected Collection $sacs;

    public function __construct()
    {
        $this->recommandations = new ArrayCollection();
        $this->sacs = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDateAdd(): ?\DateTimeImmutable
    {
        return $this->dateAdd;
    }

    public function getDateUpd(): ?\DateTimeImmutable
    {
        return $this->dateUpd;
    }

    /**
     * @return Collection<int, Recommandation>
     */
    public function getRecommandations(): Collection
    {
        return $this->recommandations;
    }

    /**
     * @return Collection<int, AnimalSac>
     */
    public function getSacs(): Collection
    {
        return $this->sacs;
    }

    /**
     * @ORM\PrePersist()
     */
    public function prePersist(): void
    {
        $this->dateAdd = new \DateTimeImmutable();
        $this->dateUpd = new \DateTimeImmutable();
    }

    /**
     * @ORM\PreUpdate()
     */
    public function preUpdate(): void
    {
        $this->dateUpd = new \DateTimeImmutable();
    }

    /**
     * @return array{0: int, 1: int}|null
     */
    public function getAge(): ?array
    {
        if (!$this->dateNaissance || '0000' === $this->dateNaissance->format('Y')) {
            return null;
        }

        $dateDiff = (new \DateTimeImmutable())->diff($this->dateNaissance);

        return [$dateDiff->y, $dateDiff->m];
    }
}
