<?php

namespace App\Tests\A_Unit\Presenter;

use Doctrine\Common\Collections\ArrayCollection;
use Myvetshop\Module\Clinique\Entity\Animal;
use Myvetshop\Module\Clinique\Entity\Recommandation;
use Myvetshop\Module\Clinique\Presenter\AnimalPresenter;
use Myvetshop\Module\Clinique\Presenter\RecommandationPresenter;
use Myvetshop\Module\Clinique\Presenter\RecommandationProductPresenter;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class RecommandationPresenterTest extends TestCase
{
    /**
     * @var AnimalPresenter&MockObject
     */
    private AnimalPresenter $animalPresenter;

    /**
     * @var RecommandationProductPresenter&MockObject
     */
    private RecommandationProductPresenter $recommandationProductPresenter;

    private RecommandationPresenter $recommandationPresenter;

    /**
     * @var Recommandation&MockObject
     */
    private Recommandation $recommandation;

    protected function setUp(): void
    {
        $this->animalPresenter = $this->createMock(AnimalPresenter::class);

        $this->recommandationProductPresenter = $this->createMock(RecommandationProductPresenter::class);

        $this->recommandationPresenter = new RecommandationPresenter(
            $this->animalPresenter,
            $this->recommandationProductPresenter
        );

        $this->recommandation = $this->createMock(Recommandation::class);
    }

    public function testPresent(): void
    {
        // Prepare the mock
        $this->recommandation->method('getId')->willReturn(1);
        $this->recommandation->method('getProduits')->willReturn(new ArrayCollection());
        $this->recommandation->espece = 'espece';
        $this->recommandation->dateReco = new \DateTimeImmutable();
        $this->recommandation->race = 'race';
        $this->recommandation->animal = $this->createMock(Animal::class);
        $this->recommandation->animal->method('getId')->willReturn(1);
        $this->recommandation->animal->nom = 'kiki';

        $result = $this->recommandationPresenter->present($this->recommandation);

        $this->assertIsArray($result);
        $this->assertArrayHasKey('id', $result);
        $this->assertEquals($this->recommandation->getId(), $result['id']);
    }
}
