{assign var='cartRule' value=null}
<form id="form-reco-{$recommandation.id}"
      action="{$link->getModuleLink('myvetshopclinique', 'myreco', ['action' => 'update', 'id_recommandation' => $recommandation.id], true)|escape:'html'}"
      method="post">
    <div class="box">
        <h1>Pour le {$recommandation.animal.espece} {$recommandation.animal.nom}</h1>
        <br>
        <table class="table table-bordered">
            <tr>
                <th>Code RECO</th>
                <td>{$recommandation.codeReco}</td>
            </tr>
            <tr>
                <th>Date d'édition</th>
                <td>{$recommandation.dateReco|date_format:"%d/%m/%Y"}</td>
            </tr>
            <tr>
                <th>Fiche animal associée</th>
                <td>
                    <div class="row" style="padding-right: 5px;">
                        <div class="col-sm-7" style="padding: 8px">
                            <select id="reco-{$recommandation.id}-animal" name="id_animal"
                                    style="vertical-align: middle; width: 100%">
                                {foreach $animals as $animal}
                                    {if $animal->espece == $recommandation.animal.espece}
                                        <option {if $animal->getId() === $recommandation.animal.id}selected=selected{/if}
                                                value="{$animal->getId()}">{$animal->nom}</option>
                                    {/if}
                                {/foreach}
                            </select>
                        </div>
                        <div class="col-sm-4" style="padding: 8px;">
                            <a
                                    href="{$link->getModuleLink('myvetshopclinique', 'myanimal', ['id_animal' => $animal->getId() ])|escape:'htmlall':'UTF-8'}"
                                    class="btn btn-primary"> <span> <i
                                            class="fas fa-paw"></i> Fiche Animal </span>
                            </a>
                        </div>
                    </div>

                </td>
            </tr>
            {if $recommandation.cartRule}
                <tr>
                    <th>Bon de réduction</th>
                    <td>
                        {if $recommandation.cartRule->code && $recommandation.cartRule->quantity > 0 && $recommandation.cartRule->active == 1 }
                            Code réduction :
                            <strong>{$recommandation.cartRule->code}</strong>
                        {else}
                            Aucun bon de réduction
                        {/if}
                    </td>
                </tr>
            {/if}
            <tr>
                <th>Consulter</th>
                <td>
                    <a target="_blank"
                       href="{$link->getModuleLink('myvetshopclinique', 'myreco')|escape:'htmlall':'UTF-8'}?action=pdf&id_recommandation={$recommandation.id}"
                       class="btn btn-primary">
                            <span>
                                <i class="fas fa-file-pdf"></i>
                                PDF
                            </span>
                    </a>
                </td>
            </tr>
        </table>
        <h2>Produit(s)</h2>
        <br>

        {include file='module:myvetshopclinique/views/templates/front/myreco/_partials/_table_reco.tpl'}

        <div>
            <p style="text-align: end"> * veuillez <a
                        target="_blank"
                        href="{$link->getModuleLink('myvetshopclinique', 'myreco', ['action' => 'pdf', 'id_recommandation' => $recommandation.id])|escape:'htmlall':'UTF-8'}"
                        style="text-decoration: underline">consuler le PDF</a> pour le détail des
                quantités journalières en fonction de l'âge de votre animal</p>
        </div>
        <div class="footer_links" style="margin-top: 12px; border: 0">
            <div style="float: right;">
                <a class="btn btn-danger" data-toggle="modal"
                   data-target="#modal-delete-reco-{$recommandation.id}" title="Supprimer">
                    <span>Supprimer <i class="fas fa-trash-alt"></i></span>
                </a>

                <!-- Modal -->
                <div class="modal fade" id="modal-delete-reco-{$recommandation.id}" tabindex="-1"
                     role="dialog" aria-labelledby="modal-delete-reco-{$recommandation.id}-label">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close close-modal" data-dismiss="modal"
                                        aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="modal-delete-reco-{$recommandation.id}-label">
                                    Voulez-vous vraiment supprimer cette recommandation ?</h4>
                            </div>
                            <div class="modal-footer" style="border-top: 0">
                                <button type="button" class="close-modal btn btn-default"
                                        data-dismiss="modal">Annuler
                                </button>
                                <a type="button"
                                   href="{$link->getModuleLink('myvetshopclinique', 'myreco', ['action' => 'delete', 'id_recommandation' => $recommandation.id], true)|escape:'html'}"
                                   class="btn btn-danger">Supprimer</a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div style="float: left;">
                <button class="btn btn-primary" type="submit" title="Mettre à jour">
                    <span>Mettre à jour <i class="fas fa-chevron-right"></i></span>
                </button>
            </div>
        </div>
    </div>
</form>
