<?php

namespace Myvetshop\Module\Clinique\Import\Serializer;

use Myvetshop\Module\Clinique\Import\Model\RewardModel;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

abstract class RewardModelNormalizer implements DenormalizerInterface
{
    /**
     * @param array<mixed> $context
     *
     * @return RewardModel
     */
    public function denormalize($data, $type, $format = null, array $context = [])
    {
        if (!\is_array($data)) {
            throw new \Exception('Invalid JSON data');
        }

        $ret = $context['object'] ?? null;

        if (!$ret) {
            throw new \Exception('No object given');
        }
        \assert($ret instanceof RewardModel);

        $ret->email = $data['email'];

        return $ret;
    }

    public function supportsDenormalization($data, $type, $format = null)
    {
        return RewardModel::class === $type;
    }
}
