<?php

namespace Myvetshop\Module\Clinique\Import\Kalivet\Serializer;

use Myvetshop\Module\Clinique\Import\Kalivet\Model\RewardModel;

class RewardModelNormalizer extends \Myvetshop\Module\Clinique\Import\Serializer\RewardModelNormalizer
{
    /**
     * @param array<mixed> $data
     *
     * @return RewardModel
     */
    public function denormalize($data, $type, $format = null, array $context = [])
    {
        /** @var RewardModel $ret */
        $ret = parent::denormalize($data, $type, $format, ['object' => new RewardModel()]);

        \assert(\is_array($data));

        $ret->credits = \floatval($data['credits']);

        return $ret;
    }

    public function supportsDenormalization($data, $type, $format = null)
    {
        return RewardModel::class === $type;
    }
}
