<?php

namespace Myvetshop\Module\Clinique\Adapter\Controller\Front;

use Doctrine\ORM\EntityManagerInterface;
use Myvetshop\Module\Clinique\Adapter\Controller\FrontControllerAdapterInterface;
use Myvetshop\Module\Clinique\Entity\Animal;
use Myvetshop\Module\Clinique\Entity\Recommandation;
use Myvetshop\Module\Clinique\Entity\RecommandationProduct;
use Myvetshop\Module\Clinique\Repository\AnimalRepository;
use Myvetshop\Module\Clinique\Repository\RecommandationRepository;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MyRecoUpdateControllerAdapter implements FrontControllerAdapterInterface
{
    private AnimalRepository $animalRepository;

    private EntityManagerInterface $entityManager;

    private RecommandationRepository $recommandationRepository;

    public function __construct(
        AnimalRepository $animalRepository,
        EntityManagerInterface $entityManager,
        RecommandationRepository $recommandationRepository
    ) {
        $this->animalRepository = $animalRepository;
        $this->entityManager = $entityManager;
        $this->recommandationRepository = $recommandationRepository;
    }

    public function handleRequest(\Context $context, Request $request): array
    {
        $optionResolver = new OptionsResolver();
        $optionResolver->setDefaults([
            'id_animal' => null,
            'id_recommandation' => null,
            'id_recommandation_product' => null,
        ]);
        $optionResolver->setAllowedTypes('id_animal', ['int', 'null']);
        $optionResolver->setAllowedTypes('id_recommandation', ['int', 'null']);
        $optionResolver->setAllowedTypes('id_recommandation_product', ['int', 'null']);
        $optionResolver->setDefined(\array_keys($request->query->all()));

        /** @var array{
         *     id_animal: int|null,
         *     id_recommandation: int|null,
         *     id_recommandation_product: int|null
         * } $queryParams
         */
        $queryParams = $optionResolver->resolve($request->query->all());

        if (
            !$queryParams['id_recommandation']
            || !$queryParams['id_recommandation_product']
            || !$queryParams['id_animal']
        ) {
            return [
                'template' => '',
                'parameters' => [],
                'redirect' => $context->link->getModuleLink('myvetshopclinique', 'myreco'),
            ];
        }

        try {
            /** @var Recommandation|null $recommandation */
            $recommandation = $this->recommandationRepository->findOneBy([
                'id' => $queryParams['id_recommandation'],
                'idCustomer' => (int) $context->customer->id,
            ]);

            /** @var Animal|null $animal */
            $animal = $this->animalRepository->findOneBy([
                'id' => $queryParams['id_animal'],
                'idCustomer' => (int) $context->customer->id,
            ]);

            $recommandationProduct = $recommandation ? $recommandation->getProduits()
                ->filter(
                    fn (RecommandationProduct $recommandationProduct) => (
                        $recommandationProduct->getId() === $queryParams['id_recommandation_product']
                    )
                )->first() : null;

            if (!$recommandation || !$recommandationProduct || !$animal) {
                throw new \Exception('Il n\'est pas possible de modifier cette recommandation.');
            }

            $recommandation->animal = $animal;
            $recommandation->idRecommandationProduct = (int) $recommandationProduct->getId();
            $animal->ration = (int) $recommandationProduct->quantity;

            $this->entityManager->flush();

            return [
                'template' => '',
                'parameters' => [],
                'success' => [
                    'La recommandation a bien été mise à jour !',
                ],
            ];
        } catch (\Exception $exception) {
            return [
                'template' => '',
                'parameters' => [],
                'errors' => [
                    $exception->getMessage(),
                ],
            ];
        }
    }
}
