<?php

namespace Myvetshop\Module\Clinique\Adapter\Controller\Front;

use Myvetshop\Module\Clinique\Adapter\Controller\FrontControllerAdapterInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MyRecoControllerAdapter implements FrontControllerAdapterInterface
{
    private MyRecoDeleteControllerAdapter $myRecoDeleteControllerAdapter;

    private MyRecoImportControllerAdapter $myRecoImportControllerAdapter;

    private MyRecoNotLoggedInControllerAdapter $myRecoNotLoggedInControllerAdapter;

    private MyRecoPdfControllerAdapter $myRecoPdfControllerAdapter;

    private MyRecoUpdateControllerAdapter $myRecoUpdateControllerAdapter;

    public function __construct(
        MyRecoDeleteControllerAdapter $myRecoDeleteControllerAdapter,
        MyRecoImportControllerAdapter $myRecoImportControllerAdapter,
        MyRecoNotLoggedInControllerAdapter $myRecoNotLoggedInControllerAdapter,
        MyRecoPdfControllerAdapter $myRecoPdfControllerAdapter,
        MyRecoUpdateControllerAdapter $myRecoUpdateControllerAdapter
    ) {
        $this->myRecoDeleteControllerAdapter = $myRecoDeleteControllerAdapter;
        $this->myRecoImportControllerAdapter = $myRecoImportControllerAdapter;
        $this->myRecoNotLoggedInControllerAdapter = $myRecoNotLoggedInControllerAdapter;
        $this->myRecoPdfControllerAdapter = $myRecoPdfControllerAdapter;
        $this->myRecoUpdateControllerAdapter = $myRecoUpdateControllerAdapter;
    }

    public function handleRequest(\Context $context, Request $request): array
    {
        $optionResolver = new OptionsResolver();
        $optionResolver->setDefaults([
            'action' => 'import',
        ]);
        $optionResolver->setAllowedTypes('action', 'string');
        $optionResolver->setAllowedValues('action', ['delete', 'import', 'pdf', 'update']);
        $optionResolver->setDefined(\array_keys($request->query->all()));

        /* @var array{action: string} $queryParams */
        $queryParams = $optionResolver->resolve($request->query->all());

        $adapter = $this->myRecoNotLoggedInControllerAdapter;

        if ($context->customer->isLogged()) {
            switch ($queryParams['action']) {
                case 'delete':
                    $adapter = $this->myRecoDeleteControllerAdapter;
                    break;

                case 'pdf':
                    $adapter = $this->myRecoPdfControllerAdapter;
                    break;

                case 'update':
                    $adapter = $this->myRecoUpdateControllerAdapter;
                    break;

                default:
                    $adapter = $this->myRecoImportControllerAdapter;
            }
        }

        return $adapter->handleRequest($context, $request);
    }
}
