<?php

declare(strict_types=1);

require_once __DIR__ . '/reporting_init.php';

use Myvetshop\Module\Clinique\Serializer\ProductCategoryReportingSerializer;

$productCategories = Db::getInstance()->executeS(
    'SELECT'
    . ' c.id_category as "id"'
    . ', cl.name as "name"'
    . ', c.id_parent as "id_parent"'
    . ', c.level_depth as "level_depth"'
    . ', c.active as "active"'
    . ' FROM ' . _DB_PREFIX_ . 'category c'
    . ' INNER JOIN ' . _DB_PREFIX_ . 'category_lang cl ON cl.id_category=c.id_category AND cl.id_lang=1'
);

if (!\is_array($productCategories)) {
    $productCategories = [];
}

echo (new ProductCategoryReportingSerializer())->serialize($productCategories);
