<?php

declare(strict_types=1);

require_once __DIR__ . '/PhpListAPI.php';

class PhpListAPIFactory
{
    /**
     * @var array<string, PhpListAPI>
     */
    protected static $cache = [];

    public static function get(string $username, string $password): PhpListAPI
    {
        if (!isset(self::$cache[$username . '-' . $password])) {
            self::$cache[$username . '-' . $password] = new PhpListAPI('myvetshop-phplist', $username, $password);
        }

        return self::$cache[$username . '-' . $password];
    }
}
