<?php

declare(strict_types=1);

class HideString
{
    /**
     * @param string $email
     *
     * @return string
     */
    public function hideEmail(string $email): string
    {
        // Format email retourné: "c*****v@m*****l.fr",

        $email = \explode('@', $email);
        $id = $email[0] ?? '';

        $domaine = \explode('.', $email[1] ?? '.');
        $nameDomaine = $domaine[0] ?? '';
        $extensionDomaine = $domaine[1] ?? '';

        return $this->hideStr($id) . '@' . $this->hideStr($nameDomaine) . '.' . $extensionDomaine;
    }

    public function hidePhoneNumber(string $phoneNumber): string
    {
        // Le numéro est divisé en deux
        // ex: "*****84523"

        $numberNbrCharacters = \strlen($phoneNumber);
        $charactersToReplace = \substr($phoneNumber, 0, (int) \ceil($numberNbrCharacters / 2));

        return str_replace($charactersToReplace, str_repeat('*', strlen($charactersToReplace)), $phoneNumber);
    }

    /**
     * @param string $str
     *
     * @return string
     */
    public function hideStr(string $str): string
    {
        if ($str) {
            $strNbrCharacters = strlen($str);

            if ($strNbrCharacters > 2) {
                $charactersToReplace = str_repeat('*', $strNbrCharacters - 2);

                $firstCharacter = $str[0];
                $lastCharacter = $str[$strNbrCharacters - 1];

                $str = $firstCharacter . $charactersToReplace . $lastCharacter;
            } elseif ($strNbrCharacters) {
                $str[0] = '*';
            }
        }

        return utf8_encode($str);
    }
}
